/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/cssfilter/lib/css.js":
/*!*******************************************!*\
  !*** ./node_modules/cssfilter/lib/css.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/cssfilter/lib/default.js");
var parseStyle = __webpack_require__(/*! ./parser */ "./node_modules/cssfilter/lib/parser.js");
var _ = __webpack_require__(/*! ./util */ "./node_modules/cssfilter/lib/util.js");


/**
 * 返回值是否为空
 *
 * @param {Object} obj
 * @return {Boolean}
 */
function isNull (obj) {
  return (obj === undefined || obj === null);
}

/**
 * 浅拷贝对象
 *
 * @param {Object} obj
 * @return {Object}
 */
function shallowCopyObject (obj) {
  var ret = {};
  for (var i in obj) {
    ret[i] = obj[i];
  }
  return ret;
}

/**
 * 创建CSS过滤器
 *
 * @param {Object} options
 *   - {Object} whiteList
 *   - {Function} onAttr
 *   - {Function} onIgnoreAttr
 *   - {Function} safeAttrValue
 */
function FilterCSS (options) {
  options = shallowCopyObject(options || {});
  options.whiteList = options.whiteList || DEFAULT.whiteList;
  options.onAttr = options.onAttr || DEFAULT.onAttr;
  options.onIgnoreAttr = options.onIgnoreAttr || DEFAULT.onIgnoreAttr;
  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
  this.options = options;
}

FilterCSS.prototype.process = function (css) {
  // 兼容各种奇葩输入
  css = css || '';
  css = css.toString();
  if (!css) return '';

  var me = this;
  var options = me.options;
  var whiteList = options.whiteList;
  var onAttr = options.onAttr;
  var onIgnoreAttr = options.onIgnoreAttr;
  var safeAttrValue = options.safeAttrValue;

  var retCSS = parseStyle(css, function (sourcePosition, position, name, value, source) {

    var check = whiteList[name];
    var isWhite = false;
    if (check === true) isWhite = check;
    else if (typeof check === 'function') isWhite = check(value);
    else if (check instanceof RegExp) isWhite = check.test(value);
    if (isWhite !== true) isWhite = false;

    // 如果过滤后 value 为空则直接忽略
    value = safeAttrValue(name, value);
    if (!value) return;

    var opts = {
      position: position,
      sourcePosition: sourcePosition,
      source: source,
      isWhite: isWhite
    };

    if (isWhite) {

      var ret = onAttr(name, value, opts);
      if (isNull(ret)) {
        return name + ':' + value;
      } else {
        return ret;
      }

    } else {

      var ret = onIgnoreAttr(name, value, opts);
      if (!isNull(ret)) {
        return ret;
      }

    }
  });

  return retCSS;
};


module.exports = FilterCSS;


/***/ }),

/***/ "./node_modules/cssfilter/lib/default.js":
/*!***********************************************!*\
  !*** ./node_modules/cssfilter/lib/default.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

function getDefaultWhiteList () {
  // 白名单值说明：
  // true: 允许该属性
  // Function: function (val) { } 返回true表示允许该属性，其他值均表示不允许
  // RegExp: regexp.test(val) 返回true表示允许该属性，其他值均表示不允许
  // 除上面列出的值外均表示不允许
  var whiteList = {};

  whiteList['align-content'] = false; // default: auto
  whiteList['align-items'] = false; // default: auto
  whiteList['align-self'] = false; // default: auto
  whiteList['alignment-adjust'] = false; // default: auto
  whiteList['alignment-baseline'] = false; // default: baseline
  whiteList['all'] = false; // default: depending on individual properties
  whiteList['anchor-point'] = false; // default: none
  whiteList['animation'] = false; // default: depending on individual properties
  whiteList['animation-delay'] = false; // default: 0
  whiteList['animation-direction'] = false; // default: normal
  whiteList['animation-duration'] = false; // default: 0
  whiteList['animation-fill-mode'] = false; // default: none
  whiteList['animation-iteration-count'] = false; // default: 1
  whiteList['animation-name'] = false; // default: none
  whiteList['animation-play-state'] = false; // default: running
  whiteList['animation-timing-function'] = false; // default: ease
  whiteList['azimuth'] = false; // default: center
  whiteList['backface-visibility'] = false; // default: visible
  whiteList['background'] = true; // default: depending on individual properties
  whiteList['background-attachment'] = true; // default: scroll
  whiteList['background-clip'] = true; // default: border-box
  whiteList['background-color'] = true; // default: transparent
  whiteList['background-image'] = true; // default: none
  whiteList['background-origin'] = true; // default: padding-box
  whiteList['background-position'] = true; // default: 0% 0%
  whiteList['background-repeat'] = true; // default: repeat
  whiteList['background-size'] = true; // default: auto
  whiteList['baseline-shift'] = false; // default: baseline
  whiteList['binding'] = false; // default: none
  whiteList['bleed'] = false; // default: 6pt
  whiteList['bookmark-label'] = false; // default: content()
  whiteList['bookmark-level'] = false; // default: none
  whiteList['bookmark-state'] = false; // default: open
  whiteList['border'] = true; // default: depending on individual properties
  whiteList['border-bottom'] = true; // default: depending on individual properties
  whiteList['border-bottom-color'] = true; // default: current color
  whiteList['border-bottom-left-radius'] = true; // default: 0
  whiteList['border-bottom-right-radius'] = true; // default: 0
  whiteList['border-bottom-style'] = true; // default: none
  whiteList['border-bottom-width'] = true; // default: medium
  whiteList['border-collapse'] = true; // default: separate
  whiteList['border-color'] = true; // default: depending on individual properties
  whiteList['border-image'] = true; // default: none
  whiteList['border-image-outset'] = true; // default: 0
  whiteList['border-image-repeat'] = true; // default: stretch
  whiteList['border-image-slice'] = true; // default: 100%
  whiteList['border-image-source'] = true; // default: none
  whiteList['border-image-width'] = true; // default: 1
  whiteList['border-left'] = true; // default: depending on individual properties
  whiteList['border-left-color'] = true; // default: current color
  whiteList['border-left-style'] = true; // default: none
  whiteList['border-left-width'] = true; // default: medium
  whiteList['border-radius'] = true; // default: 0
  whiteList['border-right'] = true; // default: depending on individual properties
  whiteList['border-right-color'] = true; // default: current color
  whiteList['border-right-style'] = true; // default: none
  whiteList['border-right-width'] = true; // default: medium
  whiteList['border-spacing'] = true; // default: 0
  whiteList['border-style'] = true; // default: depending on individual properties
  whiteList['border-top'] = true; // default: depending on individual properties
  whiteList['border-top-color'] = true; // default: current color
  whiteList['border-top-left-radius'] = true; // default: 0
  whiteList['border-top-right-radius'] = true; // default: 0
  whiteList['border-top-style'] = true; // default: none
  whiteList['border-top-width'] = true; // default: medium
  whiteList['border-width'] = true; // default: depending on individual properties
  whiteList['bottom'] = false; // default: auto
  whiteList['box-decoration-break'] = true; // default: slice
  whiteList['box-shadow'] = true; // default: none
  whiteList['box-sizing'] = true; // default: content-box
  whiteList['box-snap'] = true; // default: none
  whiteList['box-suppress'] = true; // default: show
  whiteList['break-after'] = true; // default: auto
  whiteList['break-before'] = true; // default: auto
  whiteList['break-inside'] = true; // default: auto
  whiteList['caption-side'] = false; // default: top
  whiteList['chains'] = false; // default: none
  whiteList['clear'] = true; // default: none
  whiteList['clip'] = false; // default: auto
  whiteList['clip-path'] = false; // default: none
  whiteList['clip-rule'] = false; // default: nonzero
  whiteList['color'] = true; // default: implementation dependent
  whiteList['color-interpolation-filters'] = true; // default: auto
  whiteList['column-count'] = false; // default: auto
  whiteList['column-fill'] = false; // default: balance
  whiteList['column-gap'] = false; // default: normal
  whiteList['column-rule'] = false; // default: depending on individual properties
  whiteList['column-rule-color'] = false; // default: current color
  whiteList['column-rule-style'] = false; // default: medium
  whiteList['column-rule-width'] = false; // default: medium
  whiteList['column-span'] = false; // default: none
  whiteList['column-width'] = false; // default: auto
  whiteList['columns'] = false; // default: depending on individual properties
  whiteList['contain'] = false; // default: none
  whiteList['content'] = false; // default: normal
  whiteList['counter-increment'] = false; // default: none
  whiteList['counter-reset'] = false; // default: none
  whiteList['counter-set'] = false; // default: none
  whiteList['crop'] = false; // default: auto
  whiteList['cue'] = false; // default: depending on individual properties
  whiteList['cue-after'] = false; // default: none
  whiteList['cue-before'] = false; // default: none
  whiteList['cursor'] = false; // default: auto
  whiteList['direction'] = false; // default: ltr
  whiteList['display'] = true; // default: depending on individual properties
  whiteList['display-inside'] = true; // default: auto
  whiteList['display-list'] = true; // default: none
  whiteList['display-outside'] = true; // default: inline-level
  whiteList['dominant-baseline'] = false; // default: auto
  whiteList['elevation'] = false; // default: level
  whiteList['empty-cells'] = false; // default: show
  whiteList['filter'] = false; // default: none
  whiteList['flex'] = false; // default: depending on individual properties
  whiteList['flex-basis'] = false; // default: auto
  whiteList['flex-direction'] = false; // default: row
  whiteList['flex-flow'] = false; // default: depending on individual properties
  whiteList['flex-grow'] = false; // default: 0
  whiteList['flex-shrink'] = false; // default: 1
  whiteList['flex-wrap'] = false; // default: nowrap
  whiteList['float'] = false; // default: none
  whiteList['float-offset'] = false; // default: 0 0
  whiteList['flood-color'] = false; // default: black
  whiteList['flood-opacity'] = false; // default: 1
  whiteList['flow-from'] = false; // default: none
  whiteList['flow-into'] = false; // default: none
  whiteList['font'] = true; // default: depending on individual properties
  whiteList['font-family'] = true; // default: implementation dependent
  whiteList['font-feature-settings'] = true; // default: normal
  whiteList['font-kerning'] = true; // default: auto
  whiteList['font-language-override'] = true; // default: normal
  whiteList['font-size'] = true; // default: medium
  whiteList['font-size-adjust'] = true; // default: none
  whiteList['font-stretch'] = true; // default: normal
  whiteList['font-style'] = true; // default: normal
  whiteList['font-synthesis'] = true; // default: weight style
  whiteList['font-variant'] = true; // default: normal
  whiteList['font-variant-alternates'] = true; // default: normal
  whiteList['font-variant-caps'] = true; // default: normal
  whiteList['font-variant-east-asian'] = true; // default: normal
  whiteList['font-variant-ligatures'] = true; // default: normal
  whiteList['font-variant-numeric'] = true; // default: normal
  whiteList['font-variant-position'] = true; // default: normal
  whiteList['font-weight'] = true; // default: normal
  whiteList['grid'] = false; // default: depending on individual properties
  whiteList['grid-area'] = false; // default: depending on individual properties
  whiteList['grid-auto-columns'] = false; // default: auto
  whiteList['grid-auto-flow'] = false; // default: none
  whiteList['grid-auto-rows'] = false; // default: auto
  whiteList['grid-column'] = false; // default: depending on individual properties
  whiteList['grid-column-end'] = false; // default: auto
  whiteList['grid-column-start'] = false; // default: auto
  whiteList['grid-row'] = false; // default: depending on individual properties
  whiteList['grid-row-end'] = false; // default: auto
  whiteList['grid-row-start'] = false; // default: auto
  whiteList['grid-template'] = false; // default: depending on individual properties
  whiteList['grid-template-areas'] = false; // default: none
  whiteList['grid-template-columns'] = false; // default: none
  whiteList['grid-template-rows'] = false; // default: none
  whiteList['hanging-punctuation'] = false; // default: none
  whiteList['height'] = true; // default: auto
  whiteList['hyphens'] = false; // default: manual
  whiteList['icon'] = false; // default: auto
  whiteList['image-orientation'] = false; // default: auto
  whiteList['image-resolution'] = false; // default: normal
  whiteList['ime-mode'] = false; // default: auto
  whiteList['initial-letters'] = false; // default: normal
  whiteList['inline-box-align'] = false; // default: last
  whiteList['justify-content'] = false; // default: auto
  whiteList['justify-items'] = false; // default: auto
  whiteList['justify-self'] = false; // default: auto
  whiteList['left'] = false; // default: auto
  whiteList['letter-spacing'] = true; // default: normal
  whiteList['lighting-color'] = true; // default: white
  whiteList['line-box-contain'] = false; // default: block inline replaced
  whiteList['line-break'] = false; // default: auto
  whiteList['line-grid'] = false; // default: match-parent
  whiteList['line-height'] = false; // default: normal
  whiteList['line-snap'] = false; // default: none
  whiteList['line-stacking'] = false; // default: depending on individual properties
  whiteList['line-stacking-ruby'] = false; // default: exclude-ruby
  whiteList['line-stacking-shift'] = false; // default: consider-shifts
  whiteList['line-stacking-strategy'] = false; // default: inline-line-height
  whiteList['list-style'] = true; // default: depending on individual properties
  whiteList['list-style-image'] = true; // default: none
  whiteList['list-style-position'] = true; // default: outside
  whiteList['list-style-type'] = true; // default: disc
  whiteList['margin'] = true; // default: depending on individual properties
  whiteList['margin-bottom'] = true; // default: 0
  whiteList['margin-left'] = true; // default: 0
  whiteList['margin-right'] = true; // default: 0
  whiteList['margin-top'] = true; // default: 0
  whiteList['marker-offset'] = false; // default: auto
  whiteList['marker-side'] = false; // default: list-item
  whiteList['marks'] = false; // default: none
  whiteList['mask'] = false; // default: border-box
  whiteList['mask-box'] = false; // default: see individual properties
  whiteList['mask-box-outset'] = false; // default: 0
  whiteList['mask-box-repeat'] = false; // default: stretch
  whiteList['mask-box-slice'] = false; // default: 0 fill
  whiteList['mask-box-source'] = false; // default: none
  whiteList['mask-box-width'] = false; // default: auto
  whiteList['mask-clip'] = false; // default: border-box
  whiteList['mask-image'] = false; // default: none
  whiteList['mask-origin'] = false; // default: border-box
  whiteList['mask-position'] = false; // default: center
  whiteList['mask-repeat'] = false; // default: no-repeat
  whiteList['mask-size'] = false; // default: border-box
  whiteList['mask-source-type'] = false; // default: auto
  whiteList['mask-type'] = false; // default: luminance
  whiteList['max-height'] = true; // default: none
  whiteList['max-lines'] = false; // default: none
  whiteList['max-width'] = true; // default: none
  whiteList['min-height'] = true; // default: 0
  whiteList['min-width'] = true; // default: 0
  whiteList['move-to'] = false; // default: normal
  whiteList['nav-down'] = false; // default: auto
  whiteList['nav-index'] = false; // default: auto
  whiteList['nav-left'] = false; // default: auto
  whiteList['nav-right'] = false; // default: auto
  whiteList['nav-up'] = false; // default: auto
  whiteList['object-fit'] = false; // default: fill
  whiteList['object-position'] = false; // default: 50% 50%
  whiteList['opacity'] = false; // default: 1
  whiteList['order'] = false; // default: 0
  whiteList['orphans'] = false; // default: 2
  whiteList['outline'] = false; // default: depending on individual properties
  whiteList['outline-color'] = false; // default: invert
  whiteList['outline-offset'] = false; // default: 0
  whiteList['outline-style'] = false; // default: none
  whiteList['outline-width'] = false; // default: medium
  whiteList['overflow'] = false; // default: depending on individual properties
  whiteList['overflow-wrap'] = false; // default: normal
  whiteList['overflow-x'] = false; // default: visible
  whiteList['overflow-y'] = false; // default: visible
  whiteList['padding'] = true; // default: depending on individual properties
  whiteList['padding-bottom'] = true; // default: 0
  whiteList['padding-left'] = true; // default: 0
  whiteList['padding-right'] = true; // default: 0
  whiteList['padding-top'] = true; // default: 0
  whiteList['page'] = false; // default: auto
  whiteList['page-break-after'] = false; // default: auto
  whiteList['page-break-before'] = false; // default: auto
  whiteList['page-break-inside'] = false; // default: auto
  whiteList['page-policy'] = false; // default: start
  whiteList['pause'] = false; // default: implementation dependent
  whiteList['pause-after'] = false; // default: implementation dependent
  whiteList['pause-before'] = false; // default: implementation dependent
  whiteList['perspective'] = false; // default: none
  whiteList['perspective-origin'] = false; // default: 50% 50%
  whiteList['pitch'] = false; // default: medium
  whiteList['pitch-range'] = false; // default: 50
  whiteList['play-during'] = false; // default: auto
  whiteList['position'] = false; // default: static
  whiteList['presentation-level'] = false; // default: 0
  whiteList['quotes'] = false; // default: text
  whiteList['region-fragment'] = false; // default: auto
  whiteList['resize'] = false; // default: none
  whiteList['rest'] = false; // default: depending on individual properties
  whiteList['rest-after'] = false; // default: none
  whiteList['rest-before'] = false; // default: none
  whiteList['richness'] = false; // default: 50
  whiteList['right'] = false; // default: auto
  whiteList['rotation'] = false; // default: 0
  whiteList['rotation-point'] = false; // default: 50% 50%
  whiteList['ruby-align'] = false; // default: auto
  whiteList['ruby-merge'] = false; // default: separate
  whiteList['ruby-position'] = false; // default: before
  whiteList['shape-image-threshold'] = false; // default: 0.0
  whiteList['shape-outside'] = false; // default: none
  whiteList['shape-margin'] = false; // default: 0
  whiteList['size'] = false; // default: auto
  whiteList['speak'] = false; // default: auto
  whiteList['speak-as'] = false; // default: normal
  whiteList['speak-header'] = false; // default: once
  whiteList['speak-numeral'] = false; // default: continuous
  whiteList['speak-punctuation'] = false; // default: none
  whiteList['speech-rate'] = false; // default: medium
  whiteList['stress'] = false; // default: 50
  whiteList['string-set'] = false; // default: none
  whiteList['tab-size'] = false; // default: 8
  whiteList['table-layout'] = false; // default: auto
  whiteList['text-align'] = true; // default: start
  whiteList['text-align-last'] = true; // default: auto
  whiteList['text-combine-upright'] = true; // default: none
  whiteList['text-decoration'] = true; // default: none
  whiteList['text-decoration-color'] = true; // default: currentColor
  whiteList['text-decoration-line'] = true; // default: none
  whiteList['text-decoration-skip'] = true; // default: objects
  whiteList['text-decoration-style'] = true; // default: solid
  whiteList['text-emphasis'] = true; // default: depending on individual properties
  whiteList['text-emphasis-color'] = true; // default: currentColor
  whiteList['text-emphasis-position'] = true; // default: over right
  whiteList['text-emphasis-style'] = true; // default: none
  whiteList['text-height'] = true; // default: auto
  whiteList['text-indent'] = true; // default: 0
  whiteList['text-justify'] = true; // default: auto
  whiteList['text-orientation'] = true; // default: mixed
  whiteList['text-overflow'] = true; // default: clip
  whiteList['text-shadow'] = true; // default: none
  whiteList['text-space-collapse'] = true; // default: collapse
  whiteList['text-transform'] = true; // default: none
  whiteList['text-underline-position'] = true; // default: auto
  whiteList['text-wrap'] = true; // default: normal
  whiteList['top'] = false; // default: auto
  whiteList['transform'] = false; // default: none
  whiteList['transform-origin'] = false; // default: 50% 50% 0
  whiteList['transform-style'] = false; // default: flat
  whiteList['transition'] = false; // default: depending on individual properties
  whiteList['transition-delay'] = false; // default: 0s
  whiteList['transition-duration'] = false; // default: 0s
  whiteList['transition-property'] = false; // default: all
  whiteList['transition-timing-function'] = false; // default: ease
  whiteList['unicode-bidi'] = false; // default: normal
  whiteList['vertical-align'] = false; // default: baseline
  whiteList['visibility'] = false; // default: visible
  whiteList['voice-balance'] = false; // default: center
  whiteList['voice-duration'] = false; // default: auto
  whiteList['voice-family'] = false; // default: implementation dependent
  whiteList['voice-pitch'] = false; // default: medium
  whiteList['voice-range'] = false; // default: medium
  whiteList['voice-rate'] = false; // default: normal
  whiteList['voice-stress'] = false; // default: normal
  whiteList['voice-volume'] = false; // default: medium
  whiteList['volume'] = false; // default: medium
  whiteList['white-space'] = false; // default: normal
  whiteList['widows'] = false; // default: 2
  whiteList['width'] = true; // default: auto
  whiteList['will-change'] = false; // default: auto
  whiteList['word-break'] = true; // default: normal
  whiteList['word-spacing'] = true; // default: normal
  whiteList['word-wrap'] = true; // default: normal
  whiteList['wrap-flow'] = false; // default: auto
  whiteList['wrap-through'] = false; // default: wrap
  whiteList['writing-mode'] = false; // default: horizontal-tb
  whiteList['z-index'] = false; // default: auto

  return whiteList;
}


/**
 * 匹配到白名单上的一个属性时
 *
 * @param {String} name
 * @param {String} value
 * @param {Object} options
 * @return {String}
 */
function onAttr (name, value, options) {
  // do nothing
}

/**
 * 匹配到不在白名单上的一个属性时
 *
 * @param {String} name
 * @param {String} value
 * @param {Object} options
 * @return {String}
 */
function onIgnoreAttr (name, value, options) {
  // do nothing
}

var REGEXP_URL_JAVASCRIPT = /javascript\s*\:/img;

/**
 * 过滤属性值
 *
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function safeAttrValue(name, value) {
  if (REGEXP_URL_JAVASCRIPT.test(value)) return '';
  return value;
}


exports.whiteList = getDefaultWhiteList();
exports.getDefaultWhiteList = getDefaultWhiteList;
exports.onAttr = onAttr;
exports.onIgnoreAttr = onIgnoreAttr;
exports.safeAttrValue = safeAttrValue;


/***/ }),

/***/ "./node_modules/cssfilter/lib/index.js":
/*!*********************************************!*\
  !*** ./node_modules/cssfilter/lib/index.js ***!
  \*********************************************/
/***/ ((module, exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/cssfilter/lib/default.js");
var FilterCSS = __webpack_require__(/*! ./css */ "./node_modules/cssfilter/lib/css.js");


/**
 * XSS过滤
 *
 * @param {String} css 要过滤的CSS代码
 * @param {Object} options 选项：whiteList, onAttr, onIgnoreAttr
 * @return {String}
 */
function filterCSS (html, options) {
  var xss = new FilterCSS(options);
  return xss.process(html);
}


// 输出
exports = module.exports = filterCSS;
exports.FilterCSS = FilterCSS;
for (var i in DEFAULT) exports[i] = DEFAULT[i];

// 在浏览器端使用
if (typeof window !== 'undefined') {
  window.filterCSS = module.exports;
}


/***/ }),

/***/ "./node_modules/cssfilter/lib/parser.js":
/*!**********************************************!*\
  !*** ./node_modules/cssfilter/lib/parser.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var _ = __webpack_require__(/*! ./util */ "./node_modules/cssfilter/lib/util.js");


/**
 * 解析style
 *
 * @param {String} css
 * @param {Function} onAttr 处理属性的函数
 *   参数格式： function (sourcePosition, position, name, value, source)
 * @return {String}
 */
function parseStyle (css, onAttr) {
  css = _.trimRight(css);
  if (css[css.length - 1] !== ';') css += ';';
  var cssLength = css.length;
  var isParenthesisOpen = false;
  var lastPos = 0;
  var i = 0;
  var retCSS = '';

  function addNewAttr () {
    // 如果没有正常的闭合圆括号，则直接忽略当前属性
    if (!isParenthesisOpen) {
      var source = _.trim(css.slice(lastPos, i));
      var j = source.indexOf(':');
      if (j !== -1) {
        var name = _.trim(source.slice(0, j));
        var value = _.trim(source.slice(j + 1));
        // 必须有属性名称
        if (name) {
          var ret = onAttr(lastPos, retCSS.length, name, value, source);
          if (ret) retCSS += ret + '; ';
        }
      }
    }
    lastPos = i + 1;
  }

  for (; i < cssLength; i++) {
    var c = css[i];
    if (c === '/' && css[i + 1] === '*') {
      // 备注开始
      var j = css.indexOf('*/', i + 2);
      // 如果没有正常的备注结束，则后面的部分全部跳过
      if (j === -1) break;
      // 直接将当前位置调到备注结尾，并且初始化状态
      i = j + 1;
      lastPos = i + 1;
      isParenthesisOpen = false;
    } else if (c === '(') {
      isParenthesisOpen = true;
    } else if (c === ')') {
      isParenthesisOpen = false;
    } else if (c === ';') {
      if (isParenthesisOpen) {
        // 在圆括号里面，忽略
      } else {
        addNewAttr();
      }
    } else if (c === '\n') {
      addNewAttr();
    }
  }

  return _.trim(retCSS);
}

module.exports = parseStyle;


/***/ }),

/***/ "./node_modules/cssfilter/lib/util.js":
/*!********************************************!*\
  !*** ./node_modules/cssfilter/lib/util.js ***!
  \********************************************/
/***/ ((module) => {

module.exports = {
  indexOf: function (arr, item) {
    var i, j;
    if (Array.prototype.indexOf) {
      return arr.indexOf(item);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      if (arr[i] === item) {
        return i;
      }
    }
    return -1;
  },
  forEach: function (arr, fn, scope) {
    var i, j;
    if (Array.prototype.forEach) {
      return arr.forEach(fn, scope);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      fn.call(scope, arr[i], i, arr);
    }
  },
  trim: function (str) {
    if (String.prototype.trim) {
      return str.trim();
    }
    return str.replace(/(^\s*)|(\s*$)/g, '');
  },
  trimRight: function (str) {
    if (String.prototype.trimRight) {
      return str.trimRight();
    }
    return str.replace(/(\s*$)/g, '');
  }
};


/***/ }),

/***/ "./node_modules/xss/lib/default.js":
/*!*****************************************!*\
  !*** ./node_modules/xss/lib/default.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/**
 * default settings
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var FilterCSS = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").FilterCSS);
var getDefaultCSSWhiteList = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").getDefaultWhiteList);
var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

function getDefaultWhiteList() {
  return {
    a: ["target", "href", "title"],
    abbr: ["title"],
    address: [],
    area: ["shape", "coords", "href", "alt"],
    article: [],
    aside: [],
    audio: [
      "autoplay",
      "controls",
      "crossorigin",
      "loop",
      "muted",
      "preload",
      "src",
    ],
    b: [],
    bdi: ["dir"],
    bdo: ["dir"],
    big: [],
    blockquote: ["cite"],
    br: [],
    caption: [],
    center: [],
    cite: [],
    code: [],
    col: ["align", "valign", "span", "width"],
    colgroup: ["align", "valign", "span", "width"],
    dd: [],
    del: ["datetime"],
    details: ["open"],
    div: [],
    dl: [],
    dt: [],
    em: [],
    figcaption: [],
    figure: [],
    font: ["color", "size", "face"],
    footer: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    header: [],
    hr: [],
    i: [],
    img: ["src", "alt", "title", "width", "height", "loading"],
    ins: ["datetime"],
    kbd: [],
    li: [],
    mark: [],
    nav: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    section: [],
    small: [],
    span: [],
    sub: [],
    summary: [],
    sup: [],
    strong: [],
    strike: [],
    table: ["width", "border", "align", "valign"],
    tbody: ["align", "valign"],
    td: ["width", "rowspan", "colspan", "align", "valign"],
    tfoot: ["align", "valign"],
    th: ["width", "rowspan", "colspan", "align", "valign"],
    thead: ["align", "valign"],
    tr: ["rowspan", "align", "valign"],
    tt: [],
    u: [],
    ul: [],
    video: [
      "autoplay",
      "controls",
      "crossorigin",
      "loop",
      "muted",
      "playsinline",
      "poster",
      "preload",
      "src",
      "height",
      "width",
    ],
  };
}

var defaultCSSFilter = new FilterCSS();

/**
 * default onTag function
 *
 * @param {String} tag
 * @param {String} html
 * @param {Object} options
 * @return {String}
 */
function onTag(tag, html, options) {
  // do nothing
}

/**
 * default onIgnoreTag function
 *
 * @param {String} tag
 * @param {String} html
 * @param {Object} options
 * @return {String}
 */
function onIgnoreTag(tag, html, options) {
  // do nothing
}

/**
 * default onTagAttr function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function onTagAttr(tag, name, value) {
  // do nothing
}

/**
 * default onIgnoreTagAttr function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function onIgnoreTagAttr(tag, name, value) {
  // do nothing
}

/**
 * default escapeHtml function
 *
 * @param {String} html
 */
function escapeHtml(html) {
  return html.replace(REGEXP_LT, "&lt;").replace(REGEXP_GT, "&gt;");
}

/**
 * default safeAttrValue function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @param {Object} cssFilter
 * @return {String}
 */
function safeAttrValue(tag, name, value, cssFilter) {
  // unescape attribute value firstly
  value = friendlyAttrValue(value);

  if (name === "href" || name === "src") {
    // filter `href` and `src` attribute
    // only allow the value that starts with `http://` | `https://` | `mailto:` | `/` | `#`
    value = _.trim(value);
    if (value === "#") return "#";
    if (
      !(
        value.substr(0, 7) === "http://" ||
        value.substr(0, 8) === "https://" ||
        value.substr(0, 7) === "mailto:" ||
        value.substr(0, 4) === "tel:" ||
        value.substr(0, 11) === "data:image/" ||
        value.substr(0, 6) === "ftp://" ||
        value.substr(0, 2) === "./" ||
        value.substr(0, 3) === "../" ||
        value[0] === "#" ||
        value[0] === "/"
      )
    ) {
      return "";
    }
  } else if (name === "background") {
    // filter `background` attribute (maybe no use)
    // `javascript:`
    REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
      return "";
    }
  } else if (name === "style") {
    // `expression()`
    REGEXP_DEFAULT_ON_TAG_ATTR_7.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_7.test(value)) {
      return "";
    }
    // `url()`
    REGEXP_DEFAULT_ON_TAG_ATTR_8.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_8.test(value)) {
      REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
      if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
        return "";
      }
    }
    if (cssFilter !== false) {
      cssFilter = cssFilter || defaultCSSFilter;
      value = cssFilter.process(value);
    }
  }

  // escape `<>"` before returns
  value = escapeAttrValue(value);
  return value;
}

// RegExp list
var REGEXP_LT = /</g;
var REGEXP_GT = />/g;
var REGEXP_QUOTE = /"/g;
var REGEXP_QUOTE_2 = /&quot;/g;
var REGEXP_ATTR_VALUE_1 = /&#([a-zA-Z0-9]*);?/gim;
var REGEXP_ATTR_VALUE_COLON = /&colon;?/gim;
var REGEXP_ATTR_VALUE_NEWLINE = /&newline;?/gim;
// var REGEXP_DEFAULT_ON_TAG_ATTR_3 = /\/\*|\*\//gm;
var REGEXP_DEFAULT_ON_TAG_ATTR_4 =
  /((j\s*a\s*v\s*a|v\s*b|l\s*i\s*v\s*e)\s*s\s*c\s*r\s*i\s*p\s*t\s*|m\s*o\s*c\s*h\s*a):/gi;
// var REGEXP_DEFAULT_ON_TAG_ATTR_5 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:/gi;
// var REGEXP_DEFAULT_ON_TAG_ATTR_6 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:\s*image\//gi;
var REGEXP_DEFAULT_ON_TAG_ATTR_7 =
  /e\s*x\s*p\s*r\s*e\s*s\s*s\s*i\s*o\s*n\s*\(.*/gi;
var REGEXP_DEFAULT_ON_TAG_ATTR_8 = /u\s*r\s*l\s*\(.*/gi;

/**
 * escape double quote
 *
 * @param {String} str
 * @return {String} str
 */
function escapeQuote(str) {
  return str.replace(REGEXP_QUOTE, "&quot;");
}

/**
 * unescape double quote
 *
 * @param {String} str
 * @return {String} str
 */
function unescapeQuote(str) {
  return str.replace(REGEXP_QUOTE_2, '"');
}

/**
 * escape html entities
 *
 * @param {String} str
 * @return {String}
 */
function escapeHtmlEntities(str) {
  return str.replace(REGEXP_ATTR_VALUE_1, function replaceUnicode(str, code) {
    return code[0] === "x" || code[0] === "X"
      ? String.fromCharCode(parseInt(code.substr(1), 16))
      : String.fromCharCode(parseInt(code, 10));
  });
}

/**
 * escape html5 new danger entities
 *
 * @param {String} str
 * @return {String}
 */
function escapeDangerHtml5Entities(str) {
  return str
    .replace(REGEXP_ATTR_VALUE_COLON, ":")
    .replace(REGEXP_ATTR_VALUE_NEWLINE, " ");
}

/**
 * clear nonprintable characters
 *
 * @param {String} str
 * @return {String}
 */
function clearNonPrintableCharacter(str) {
  var str2 = "";
  for (var i = 0, len = str.length; i < len; i++) {
    str2 += str.charCodeAt(i) < 32 ? " " : str.charAt(i);
  }
  return _.trim(str2);
}

/**
 * get friendly attribute value
 *
 * @param {String} str
 * @return {String}
 */
function friendlyAttrValue(str) {
  str = unescapeQuote(str);
  str = escapeHtmlEntities(str);
  str = escapeDangerHtml5Entities(str);
  str = clearNonPrintableCharacter(str);
  return str;
}

/**
 * unescape attribute value
 *
 * @param {String} str
 * @return {String}
 */
function escapeAttrValue(str) {
  str = escapeQuote(str);
  str = escapeHtml(str);
  return str;
}

/**
 * `onIgnoreTag` function for removing all the tags that are not in whitelist
 */
function onIgnoreTagStripAll() {
  return "";
}

/**
 * remove tag body
 * specify a `tags` list, if the tag is not in the `tags` list then process by the specify function (optional)
 *
 * @param {array} tags
 * @param {function} next
 */
function StripTagBody(tags, next) {
  if (typeof next !== "function") {
    next = function () {};
  }

  var isRemoveAllTag = !Array.isArray(tags);
  function isRemoveTag(tag) {
    if (isRemoveAllTag) return true;
    return _.indexOf(tags, tag) !== -1;
  }

  var removeList = [];
  var posStart = false;

  return {
    onIgnoreTag: function (tag, html, options) {
      if (isRemoveTag(tag)) {
        if (options.isClosing) {
          var ret = "[/removed]";
          var end = options.position + ret.length;
          removeList.push([
            posStart !== false ? posStart : options.position,
            end,
          ]);
          posStart = false;
          return ret;
        } else {
          if (!posStart) {
            posStart = options.position;
          }
          return "[removed]";
        }
      } else {
        return next(tag, html, options);
      }
    },
    remove: function (html) {
      var rethtml = "";
      var lastPos = 0;
      _.forEach(removeList, function (pos) {
        rethtml += html.slice(lastPos, pos[0]);
        lastPos = pos[1];
      });
      rethtml += html.slice(lastPos);
      return rethtml;
    },
  };
}

/**
 * remove html comments
 *
 * @param {String} html
 * @return {String}
 */
function stripCommentTag(html) {
  var retHtml = "";
  var lastPos = 0;
  while (lastPos < html.length) {
    var i = html.indexOf("<!--", lastPos);
    if (i === -1) {
      retHtml += html.slice(lastPos);
      break;
    }
    retHtml += html.slice(lastPos, i);
    var j = html.indexOf("-->", i);
    if (j === -1) {
      break;
    }
    lastPos = j + 3;
  }
  return retHtml;
}

/**
 * remove invisible characters
 *
 * @param {String} html
 * @return {String}
 */
function stripBlankChar(html) {
  var chars = html.split("");
  chars = chars.filter(function (char) {
    var c = char.charCodeAt(0);
    if (c === 127) return false;
    if (c <= 31) {
      if (c === 10 || c === 13) return true;
      return false;
    }
    return true;
  });
  return chars.join("");
}

exports.whiteList = getDefaultWhiteList();
exports.getDefaultWhiteList = getDefaultWhiteList;
exports.onTag = onTag;
exports.onIgnoreTag = onIgnoreTag;
exports.onTagAttr = onTagAttr;
exports.onIgnoreTagAttr = onIgnoreTagAttr;
exports.safeAttrValue = safeAttrValue;
exports.escapeHtml = escapeHtml;
exports.escapeQuote = escapeQuote;
exports.unescapeQuote = unescapeQuote;
exports.escapeHtmlEntities = escapeHtmlEntities;
exports.escapeDangerHtml5Entities = escapeDangerHtml5Entities;
exports.clearNonPrintableCharacter = clearNonPrintableCharacter;
exports.friendlyAttrValue = friendlyAttrValue;
exports.escapeAttrValue = escapeAttrValue;
exports.onIgnoreTagStripAll = onIgnoreTagStripAll;
exports.StripTagBody = StripTagBody;
exports.stripCommentTag = stripCommentTag;
exports.stripBlankChar = stripBlankChar;
exports.attributeWrapSign = '"';
exports.cssFilter = defaultCSSFilter;
exports.getDefaultCSSWhiteList = getDefaultCSSWhiteList;


/***/ }),

/***/ "./node_modules/xss/lib/index.js":
/*!***************************************!*\
  !*** ./node_modules/xss/lib/index.js ***!
  \***************************************/
/***/ ((module, exports, __webpack_require__) => {

/**
 * xss
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/xss/lib/default.js");
var parser = __webpack_require__(/*! ./parser */ "./node_modules/xss/lib/parser.js");
var FilterXSS = __webpack_require__(/*! ./xss */ "./node_modules/xss/lib/xss.js");

/**
 * filter xss function
 *
 * @param {String} html
 * @param {Object} options { whiteList, onTag, onTagAttr, onIgnoreTag, onIgnoreTagAttr, safeAttrValue, escapeHtml }
 * @return {String}
 */
function filterXSS(html, options) {
  var xss = new FilterXSS(options);
  return xss.process(html);
}

exports = module.exports = filterXSS;
exports.filterXSS = filterXSS;
exports.FilterXSS = FilterXSS;

(function () {
  for (var i in DEFAULT) {
    exports[i] = DEFAULT[i];
  }
  for (var j in parser) {
    exports[j] = parser[j];
  }
})();

// using `xss` on the browser, output `filterXSS` to the globals
if (typeof window !== "undefined") {
  window.filterXSS = module.exports;
}

// using `xss` on the WebWorker, output `filterXSS` to the globals
function isWorkerEnv() {
  return (
    typeof self !== "undefined" &&
    typeof DedicatedWorkerGlobalScope !== "undefined" &&
    self instanceof DedicatedWorkerGlobalScope
  );
}
if (isWorkerEnv()) {
  self.filterXSS = module.exports;
}


/***/ }),

/***/ "./node_modules/xss/lib/parser.js":
/*!****************************************!*\
  !*** ./node_modules/xss/lib/parser.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/**
 * Simple HTML Parser
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

/**
 * get tag name
 *
 * @param {String} html e.g. '<a hef="#">'
 * @return {String}
 */
function getTagName(html) {
  var i = _.spaceIndex(html);
  var tagName;
  if (i === -1) {
    tagName = html.slice(1, -1);
  } else {
    tagName = html.slice(1, i + 1);
  }
  tagName = _.trim(tagName).toLowerCase();
  if (tagName.slice(0, 1) === "/") tagName = tagName.slice(1);
  if (tagName.slice(-1) === "/") tagName = tagName.slice(0, -1);
  return tagName;
}

/**
 * is close tag?
 *
 * @param {String} html 如：'<a hef="#">'
 * @return {Boolean}
 */
function isClosing(html) {
  return html.slice(0, 2) === "</";
}

/**
 * parse input html and returns processed html
 *
 * @param {String} html
 * @param {Function} onTag e.g. function (sourcePosition, position, tag, html, isClosing)
 * @param {Function} escapeHtml
 * @return {String}
 */
function parseTag(html, onTag, escapeHtml) {
  "use strict";

  var rethtml = "";
  var lastPos = 0;
  var tagStart = false;
  var quoteStart = false;
  var currentPos = 0;
  var len = html.length;
  var currentTagName = "";
  var currentHtml = "";

  chariterator: for (currentPos = 0; currentPos < len; currentPos++) {
    var c = html.charAt(currentPos);
    if (tagStart === false) {
      if (c === "<") {
        tagStart = currentPos;
        continue;
      }
    } else {
      if (quoteStart === false) {
        if (c === "<") {
          rethtml += escapeHtml(html.slice(lastPos, currentPos));
          tagStart = currentPos;
          lastPos = currentPos;
          continue;
        }
        if (c === ">" || currentPos === len - 1) {
          rethtml += escapeHtml(html.slice(lastPos, tagStart));
          currentHtml = html.slice(tagStart, currentPos + 1);
          currentTagName = getTagName(currentHtml);
          rethtml += onTag(
            tagStart,
            rethtml.length,
            currentTagName,
            currentHtml,
            isClosing(currentHtml)
          );
          lastPos = currentPos + 1;
          tagStart = false;
          continue;
        }
        if (c === '"' || c === "'") {
          var i = 1;
          var ic = html.charAt(currentPos - i);

          while (ic.trim() === "" || ic === "=") {
            if (ic === "=") {
              quoteStart = c;
              continue chariterator;
            }
            ic = html.charAt(currentPos - ++i);
          }
        }
      } else {
        if (c === quoteStart) {
          quoteStart = false;
          continue;
        }
      }
    }
  }
  if (lastPos < len) {
    rethtml += escapeHtml(html.substr(lastPos));
  }

  return rethtml;
}

var REGEXP_ILLEGAL_ATTR_NAME = /[^a-zA-Z0-9\\_:.-]/gim;

/**
 * parse input attributes and returns processed attributes
 *
 * @param {String} html e.g. `href="#" target="_blank"`
 * @param {Function} onAttr e.g. `function (name, value)`
 * @return {String}
 */
function parseAttr(html, onAttr) {
  "use strict";

  var lastPos = 0;
  var lastMarkPos = 0;
  var retAttrs = [];
  var tmpName = false;
  var len = html.length;

  function addAttr(name, value) {
    name = _.trim(name);
    name = name.replace(REGEXP_ILLEGAL_ATTR_NAME, "").toLowerCase();
    if (name.length < 1) return;
    var ret = onAttr(name, value || "");
    if (ret) retAttrs.push(ret);
  }

  // 逐个分析字符
  for (var i = 0; i < len; i++) {
    var c = html.charAt(i);
    var v, j;
    if (tmpName === false && c === "=") {
      tmpName = html.slice(lastPos, i);
      lastPos = i + 1;
      lastMarkPos = html.charAt(lastPos) === '"' || html.charAt(lastPos) === "'" ? lastPos : findNextQuotationMark(html, i + 1);
      continue;
    }
    if (tmpName !== false) {
      if (
        i === lastMarkPos
      ) {
        j = html.indexOf(c, i + 1);
        if (j === -1) {
          break;
        } else {
          v = _.trim(html.slice(lastMarkPos + 1, j));
          addAttr(tmpName, v);
          tmpName = false;
          i = j;
          lastPos = i + 1;
          continue;
        }
      }
    }
    if (/\s|\n|\t/.test(c)) {
      html = html.replace(/\s|\n|\t/g, " ");
      if (tmpName === false) {
        j = findNextEqual(html, i);
        if (j === -1) {
          v = _.trim(html.slice(lastPos, i));
          addAttr(v);
          tmpName = false;
          lastPos = i + 1;
          continue;
        } else {
          i = j - 1;
          continue;
        }
      } else {
        j = findBeforeEqual(html, i - 1);
        if (j === -1) {
          v = _.trim(html.slice(lastPos, i));
          v = stripQuoteWrap(v);
          addAttr(tmpName, v);
          tmpName = false;
          lastPos = i + 1;
          continue;
        } else {
          continue;
        }
      }
    }
  }

  if (lastPos < html.length) {
    if (tmpName === false) {
      addAttr(html.slice(lastPos));
    } else {
      addAttr(tmpName, stripQuoteWrap(_.trim(html.slice(lastPos))));
    }
  }

  return _.trim(retAttrs.join(" "));
}

function findNextEqual(str, i) {
  for (; i < str.length; i++) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "=") return i;
    return -1;
  }
}

function findNextQuotationMark(str, i) {
  for (; i < str.length; i++) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "'" || c === '"') return i;
    return -1;
  }
}

function findBeforeEqual(str, i) {
  for (; i > 0; i--) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "=") return i;
    return -1;
  }
}

function isQuoteWrapString(text) {
  if (
    (text[0] === '"' && text[text.length - 1] === '"') ||
    (text[0] === "'" && text[text.length - 1] === "'")
  ) {
    return true;
  } else {
    return false;
  }
}

function stripQuoteWrap(text) {
  if (isQuoteWrapString(text)) {
    return text.substr(1, text.length - 2);
  } else {
    return text;
  }
}

exports.parseTag = parseTag;
exports.parseAttr = parseAttr;


/***/ }),

/***/ "./node_modules/xss/lib/util.js":
/*!**************************************!*\
  !*** ./node_modules/xss/lib/util.js ***!
  \**************************************/
/***/ ((module) => {

module.exports = {
  indexOf: function (arr, item) {
    var i, j;
    if (Array.prototype.indexOf) {
      return arr.indexOf(item);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      if (arr[i] === item) {
        return i;
      }
    }
    return -1;
  },
  forEach: function (arr, fn, scope) {
    var i, j;
    if (Array.prototype.forEach) {
      return arr.forEach(fn, scope);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      fn.call(scope, arr[i], i, arr);
    }
  },
  trim: function (str) {
    if (String.prototype.trim) {
      return str.trim();
    }
    return str.replace(/(^\s*)|(\s*$)/g, "");
  },
  spaceIndex: function (str) {
    var reg = /\s|\n|\t/;
    var match = reg.exec(str);
    return match ? match.index : -1;
  },
};


/***/ }),

/***/ "./node_modules/xss/lib/xss.js":
/*!*************************************!*\
  !*** ./node_modules/xss/lib/xss.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * filter xss
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var FilterCSS = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").FilterCSS);
var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/xss/lib/default.js");
var parser = __webpack_require__(/*! ./parser */ "./node_modules/xss/lib/parser.js");
var parseTag = parser.parseTag;
var parseAttr = parser.parseAttr;
var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

/**
 * returns `true` if the input value is `undefined` or `null`
 *
 * @param {Object} obj
 * @return {Boolean}
 */
function isNull(obj) {
  return obj === undefined || obj === null;
}

/**
 * get attributes for a tag
 *
 * @param {String} html
 * @return {Object}
 *   - {String} html
 *   - {Boolean} closing
 */
function getAttrs(html) {
  var i = _.spaceIndex(html);
  if (i === -1) {
    return {
      html: "",
      closing: html[html.length - 2] === "/",
    };
  }
  html = _.trim(html.slice(i + 1, -1));
  var isClosing = html[html.length - 1] === "/";
  if (isClosing) html = _.trim(html.slice(0, -1));
  return {
    html: html,
    closing: isClosing,
  };
}

/**
 * shallow copy
 *
 * @param {Object} obj
 * @return {Object}
 */
function shallowCopyObject(obj) {
  var ret = {};
  for (var i in obj) {
    ret[i] = obj[i];
  }
  return ret;
}

function keysToLowerCase(obj) {
  var ret = {};
  for (var i in obj) {
    if (Array.isArray(obj[i])) {
      ret[i.toLowerCase()] = obj[i].map(function (item) {
        return item.toLowerCase();
      });
    } else {
      ret[i.toLowerCase()] = obj[i];
    }
  }
  return ret;
}

/**
 * FilterXSS class
 *
 * @param {Object} options
 *        whiteList (or allowList), onTag, onTagAttr, onIgnoreTag,
 *        onIgnoreTagAttr, safeAttrValue, escapeHtml
 *        stripIgnoreTagBody, allowCommentTag, stripBlankChar
 *        css{whiteList, onAttr, onIgnoreAttr} `css=false` means don't use `cssfilter`
 */
function FilterXSS(options) {
  options = shallowCopyObject(options || {});

  if (options.stripIgnoreTag) {
    if (options.onIgnoreTag) {
      console.error(
        'Notes: cannot use these two options "stripIgnoreTag" and "onIgnoreTag" at the same time'
      );
    }
    options.onIgnoreTag = DEFAULT.onIgnoreTagStripAll;
  }
  if (options.whiteList || options.allowList) {
    options.whiteList = keysToLowerCase(options.whiteList || options.allowList);
  } else {
    options.whiteList = DEFAULT.whiteList;
  }

  this.attributeWrapSign = options.singleQuotedAttributeValue === true ? "'" : DEFAULT.attributeWrapSign;

  options.onTag = options.onTag || DEFAULT.onTag;
  options.onTagAttr = options.onTagAttr || DEFAULT.onTagAttr;
  options.onIgnoreTag = options.onIgnoreTag || DEFAULT.onIgnoreTag;
  options.onIgnoreTagAttr = options.onIgnoreTagAttr || DEFAULT.onIgnoreTagAttr;
  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
  options.escapeHtml = options.escapeHtml || DEFAULT.escapeHtml;
  this.options = options;

  if (options.css === false) {
    this.cssFilter = false;
  } else {
    options.css = options.css || {};
    this.cssFilter = new FilterCSS(options.css);
  }
}

/**
 * start process and returns result
 *
 * @param {String} html
 * @return {String}
 */
FilterXSS.prototype.process = function (html) {
  // compatible with the input
  html = html || "";
  html = html.toString();
  if (!html) return "";

  var me = this;
  var options = me.options;
  var whiteList = options.whiteList;
  var onTag = options.onTag;
  var onIgnoreTag = options.onIgnoreTag;
  var onTagAttr = options.onTagAttr;
  var onIgnoreTagAttr = options.onIgnoreTagAttr;
  var safeAttrValue = options.safeAttrValue;
  var escapeHtml = options.escapeHtml;
  var attributeWrapSign = me.attributeWrapSign;
  var cssFilter = me.cssFilter;

  // remove invisible characters
  if (options.stripBlankChar) {
    html = DEFAULT.stripBlankChar(html);
  }

  // remove html comments
  if (!options.allowCommentTag) {
    html = DEFAULT.stripCommentTag(html);
  }

  // if enable stripIgnoreTagBody
  var stripIgnoreTagBody = false;
  if (options.stripIgnoreTagBody) {
    stripIgnoreTagBody = DEFAULT.StripTagBody(
      options.stripIgnoreTagBody,
      onIgnoreTag
    );
    onIgnoreTag = stripIgnoreTagBody.onIgnoreTag;
  }

  var retHtml = parseTag(
    html,
    function (sourcePosition, position, tag, html, isClosing) {
      var info = {
        sourcePosition: sourcePosition,
        position: position,
        isClosing: isClosing,
        isWhite: Object.prototype.hasOwnProperty.call(whiteList, tag),
      };

      // call `onTag()`
      var ret = onTag(tag, html, info);
      if (!isNull(ret)) return ret;

      if (info.isWhite) {
        if (info.isClosing) {
          return "</" + tag + ">";
        }

        var attrs = getAttrs(html);
        var whiteAttrList = whiteList[tag];
        var attrsHtml = parseAttr(attrs.html, function (name, value) {
          // call `onTagAttr()`
          var isWhiteAttr = _.indexOf(whiteAttrList, name) !== -1;
          var ret = onTagAttr(tag, name, value, isWhiteAttr);
          if (!isNull(ret)) return ret;

          if (isWhiteAttr) {
            // call `safeAttrValue()`
            value = safeAttrValue(tag, name, value, cssFilter);
            if (value) {
              return name + '=' + attributeWrapSign + value + attributeWrapSign;
            } else {
              return name;
            }
          } else {
            // call `onIgnoreTagAttr()`
            ret = onIgnoreTagAttr(tag, name, value, isWhiteAttr);
            if (!isNull(ret)) return ret;
            return;
          }
        });

        // build new tag html
        html = "<" + tag;
        if (attrsHtml) html += " " + attrsHtml;
        if (attrs.closing) html += " /";
        html += ">";
        return html;
      } else {
        // call `onIgnoreTag()`
        ret = onIgnoreTag(tag, html, info);
        if (!isNull(ret)) return ret;
        return escapeHtml(html);
      }
    },
    escapeHtml
  );

  // if enable stripIgnoreTagBody
  if (stripIgnoreTagBody) {
    retHtml = stripIgnoreTagBody.remove(retHtml);
  }

  return retHtml;
};

module.exports = FilterXSS;


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**************************!*\
  !*** ./js/sb-youtube.js ***!
  \**************************/
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var xss = __webpack_require__(/*! xss */ "./node_modules/xss/lib/index.js");
var sby_js_exists = typeof sby_js_exists !== 'undefined' ? true : false;
if (!sby_js_exists) {
  /**
   * Sanitize string by escaping HTML entities
   * @param input
   * @returns {string}
   */
  var sbyEncodeInput = function sbyEncodeInput(input) {
    return xss(input);
  };
  var sbyAddImgLiquid = function sbyAddImgLiquid() {
    /*! imgLiquid v0.9.944 / 03-05-2013 https://github.com/karacas/imgLiquid */
    var _sby_imgLiquid = _sby_imgLiquid || {
      VER: "0.9.944"
    };
    _sby_imgLiquid.bgs_Available = !1, _sby_imgLiquid.bgs_CheckRunned = !1, function (i) {
      function t() {
        if (!_sby_imgLiquid.bgs_CheckRunned) {
          _sby_imgLiquid.bgs_CheckRunned = !0;
          var t = i('<span style="background-size:cover" />');
          i("body").append(t), !function () {
            var i = t[0];
            if (i && window.getComputedStyle) {
              var e = window.getComputedStyle(i, null);
              e && e.backgroundSize && (_sby_imgLiquid.bgs_Available = "cover" === e.backgroundSize);
            }
          }(), t.remove();
        }
      }
      i.fn.extend({
        sby_imgLiquid: function sby_imgLiquid(e) {
          this.defaults = {
            fill: !0,
            verticalAlign: "center",
            horizontalAlign: "center",
            useBackgroundSize: !0,
            useDataHtmlAttr: !0,
            responsive: !0,
            delay: 0,
            fadeInTime: 0,
            removeBoxBackground: !0,
            hardPixels: !0,
            responsiveCheckTime: 500,
            timecheckvisibility: 500,
            onStart: null,
            onFinish: null,
            onItemStart: null,
            onItemFinish: null,
            onItemError: null
          }, t();
          var a = this;
          return this.options = e, this.settings = i.extend({}, this.defaults, this.options), this.settings.onStart && this.settings.onStart(), this.each(function (t) {
            function e() {
              -1 === u.css("background-image").indexOf(encodeURI(c.attr("src"))) && u.css({
                "background-image": 'url("' + encodeURI(c.attr("src")) + '")'
              }), u.css({
                "background-size": g.fill ? "cover" : "contain",
                "background-position": (g.horizontalAlign + " " + g.verticalAlign).toLowerCase(),
                "background-repeat": "no-repeat"
              }), i("a:first", u).css({
                display: "block",
                width: "100%",
                height: "100%"
              }), i("img", u).css({
                display: "none"
              }), g.onItemFinish && g.onItemFinish(t, u, c), u.addClass("sby_imgLiquid_bgSize"), u.addClass("sby_imgLiquid_ready"), l();
            }
            function o() {
              function e() {
                c.data("sby_imgLiquid_error") || c.data("sby_imgLiquid_loaded") || c.data("sby_imgLiquid_oldProcessed") || (u.is(":visible") && c[0].complete && c[0].width > 0 && c[0].height > 0 ? (c.data("sby_imgLiquid_loaded", !0), setTimeout(r, t * g.delay)) : setTimeout(e, g.timecheckvisibility));
              }
              if (c.data("oldSrc") && c.data("oldSrc") !== c.attr("src")) {
                var a = c.clone().removeAttr("style");
                return a.data("sby_imgLiquid_settings", c.data("sby_imgLiquid_settings")), c.parent().prepend(a), c.remove(), c = a, c[0].width = 0, void setTimeout(o, 10);
              }
              return c.data("sby_imgLiquid_oldProcessed") ? void r() : (c.data("sby_imgLiquid_oldProcessed", !1), c.data("oldSrc", c.attr("src")), i("img:not(:first)", u).css("display", "none"), u.css({
                overflow: "hidden"
              }), c.fadeTo(0, 0).removeAttr("width").removeAttr("height").css({
                visibility: "visible",
                "max-width": "none",
                "max-height": "none",
                width: "auto",
                height: "auto",
                display: "block"
              }), c.on("error", n), c[0].onerror = n, e(), void d());
            }
            function d() {
              (g.responsive || c.data("sby_imgLiquid_oldProcessed")) && c.data("sby_imgLiquid_settings") && (g = c.data("sby_imgLiquid_settings"), u.actualSize = u.get(0).offsetWidth + u.get(0).offsetHeight / 1e4, u.sizeOld && u.actualSize !== u.sizeOld && r(), u.sizeOld = u.actualSize, setTimeout(d, g.responsiveCheckTime));
            }
            function n() {
              c.data("sby_imgLiquid_error", !0), u.addClass("sby_imgLiquid_error"), g.onItemError && g.onItemError(t, u, c), l();
            }
            function s() {
              var i = {};
              if (a.settings.useDataHtmlAttr) {
                var t = u.attr("data-sby_imgLiquid-fill"),
                  e = u.attr("data-sby_imgLiquid-horizontalAlign"),
                  o = u.attr("data-sby_imgLiquid-verticalAlign");
                ("true" === t || "false" === t) && (i.fill = Boolean("true" === t)), void 0 === e || "left" !== e && "center" !== e && "right" !== e && -1 === e.indexOf("%") || (i.horizontalAlign = e), void 0 === o || "top" !== o && "bottom" !== o && "center" !== o && -1 === o.indexOf("%") || (i.verticalAlign = o);
              }
              return _sby_imgLiquid.isIE && a.settings.ieFadeInDisabled && (i.fadeInTime = 0), i;
            }
            function r() {
              var i,
                e,
                a,
                o,
                d,
                n,
                s,
                r,
                m = 0,
                h = 0,
                f = u.width(),
                v = u.height();
              void 0 === c.data("owidth") && c.data("owidth", c[0].width), void 0 === c.data("oheight") && c.data("oheight", c[0].height), g.fill === f / v >= c.data("owidth") / c.data("oheight") ? (i = "100%", e = "auto", a = Math.floor(f), o = Math.floor(f * (c.data("oheight") / c.data("owidth")))) : (i = "auto", e = "100%", a = Math.floor(v * (c.data("owidth") / c.data("oheight"))), o = Math.floor(v)), d = g.horizontalAlign.toLowerCase(), s = f - a, "left" === d && (h = 0), "center" === d && (h = .5 * s), "right" === d && (h = s), -1 !== d.indexOf("%") && (d = parseInt(d.replace("%", ""), 10), d > 0 && (h = s * d * .01)), n = g.verticalAlign.toLowerCase(), r = v - o, "left" === n && (m = 0), "center" === n && (m = .5 * r), "bottom" === n && (m = r), -1 !== n.indexOf("%") && (n = parseInt(n.replace("%", ""), 10), n > 0 && (m = r * n * .01)), g.hardPixels && (i = a, e = o), c.css({
                width: i,
                height: e,
                "margin-left": Math.floor(h),
                "margin-top": Math.floor(m)
              }), c.data("sby_imgLiquid_oldProcessed") || (c.fadeTo(g.fadeInTime, 1), c.data("sby_imgLiquid_oldProcessed", !0), g.removeBoxBackground && u.css("background-image", "none"), u.addClass("sby_imgLiquid_nobgSize"), u.addClass("sby_imgLiquid_ready")), g.onItemFinish && g.onItemFinish(t, u, c), l();
            }
            function l() {
              t === a.length - 1 && a.settings.onFinish && a.settings.onFinish();
            }
            var g = a.settings,
              u = i(this),
              c = i("img:first", u);
            return c.length ? (c.data("sby_imgLiquid_settings") ? (u.removeClass("sby_imgLiquid_error").removeClass("sby_imgLiquid_ready"), g = i.extend({}, c.data("sby_imgLiquid_settings"), a.options)) : g = i.extend({}, a.settings, s()), c.data("sby_imgLiquid_settings", g), g.onItemStart && g.onItemStart(t, u, c), void (_sby_imgLiquid.bgs_Available && g.useBackgroundSize ? e() : o())) : void n();
          });
        }
      });
    }(jQuery);

    // Use imagefill to set the images as backgrounds so they can be square
    !function () {
      var css = _sby_imgLiquid.injectCss,
        head = document.getElementsByTagName('head')[0],
        style = document.createElement('style');
      style.type = 'text/css';
      if (style.styleSheet) {
        style.styleSheet.cssText = css;
      } else {
        style.appendChild(document.createTextNode(css));
      }
      head.appendChild(style);
    }();
  };
  /* JavaScript Linkify - v0.3 - 6/27/2009 - http://benalman.com/projects/javascript-linkify/ */
  //Checks whether browser support HTML5 video element
  var sby_supports_video = function sby_supports_video() {
    return !!document.createElement('video').canPlayType;
  }; // Carousel
  window.sbyLinkify = function () {
    var k = "[a-z\\d.-]+://",
      h = "(?:(?:[0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.){3}(?:[0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])",
      c = "(?:(?:[^\\s!@#$%^&*()_=+[\\]{}\\\\|;:'\",.<>/?]+)\\.)+",
      n = "(?:ac|ad|aero|ae|af|ag|ai|al|am|an|ao|aq|arpa|ar|asia|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|biz|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|cat|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|coop|com|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|edu|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gov|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|info|int|in|io|iq|ir|is|it|je|jm|jobs|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mil|mk|ml|mm|mn|mobi|mo|mp|mq|mr|ms|mt|museum|mu|mv|mw|mx|my|mz|name|na|nc|net|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|org|pa|pe|pf|pg|ph|pk|pl|pm|pn|pro|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sy|sz|tc|td|tel|tf|tg|th|tj|tk|tl|tm|tn|to|tp|travel|tr|tt|tv|tw|tz|ua|ug|uk|um|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|xn--0zwm56d|xn--11b5bs3a9aj6g|xn--80akhbyknj4f|xn--9t4b11yi5a|xn--deba0ad|xn--g6w251d|xn--hgbk6aj7f53bba|xn--hlcj6aya9esc7a|xn--jxalpdlp|xn--kgbechtv|xn--zckzah|ye|yt|yu|za|zm|zw)",
      f = "(?:" + c + n + "|" + h + ")",
      o = "(?:[;/][^#?<>\\s]*)?",
      e = "(?:\\?[^#<>\\s]*)?(?:#[^<>\\s]*)?",
      d = "\\b" + k + "[^<>\\s]+",
      a = "\\b" + f + o + e + "(?!\\w)",
      m = "mailto:",
      j = "(?:" + m + ")?[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@" + f + e + "(?!\\w)",
      l = new RegExp("(?:" + d + "|" + a + "|" + j + ")", "ig"),
      g = new RegExp("^" + k, "i"),
      b = {
        "'": "`",
        ">": "<",
        ")": "(",
        "]": "[",
        "}": "{",
        "B;": "B+",
        "b:": "b9"
      },
      i = {
        callback: function callback(q, p) {
          return p ? '<a href="' + p + '" title="' + p + '" target="_blank" rel="noopener">' + q + "</a>" : q;
        },
        punct_regexp: /(?:[!?.,:;'"]|(?:&|&amp;)(?:lt|gt|quot|apos|raquo|laquo|rsaquo|lsaquo);)$/
      };
    return function (u, z) {
      z = z || {};
      var w,
        v,
        A,
        p,
        x = "",
        t = [],
        s,
        E,
        C,
        y,
        q,
        D,
        B,
        r;
      for (v in i) {
        if (z[v] === undefined) {
          z[v] = i[v];
        }
      }
      while (w = l.exec(u)) {
        A = w[0];
        E = l.lastIndex;
        C = E - A.length;
        if (/[\/:]/.test(u.charAt(C - 1))) {
          continue;
        }
        do {
          y = A;
          r = A.substr(-1);
          B = b[r];
          if (B) {
            q = A.match(new RegExp("\\" + B + "(?!$)", "g"));
            D = A.match(new RegExp("\\" + r, "g"));
            if ((q ? q.length : 0) < (D ? D.length : 0)) {
              A = A.substr(0, A.length - 1);
              E--;
            }
          }
          if (z.punct_regexp) {
            A = A.replace(z.punct_regexp, function (F) {
              E -= F.length;
              return "";
            });
          }
        } while (A.length && A !== y);
        p = A;
        if (!g.test(p)) {
          p = (p.indexOf("@") !== -1 ? !p.indexOf(m) ? "" : m : !p.indexOf("irc.") ? "irc://" : !p.indexOf("ftp.") ? "ftp://" : "http://") + p;
        }
        if (s != C) {
          t.push([u.slice(s, C)]);
          s = E;
        }
        t.push([A, p]);
      }
      t.push([u.substr(s)]);
      for (v = 0; v < t.length; v++) {
        x += z.callback.apply(window, t[v]);
      }
      return x || u;
    };
  }();
  !function (a, b, c, d) {
    function e(b, c) {
      this.settings = null, this.options = a.extend({}, e.Defaults, c), this.$element = a(b), this._handlers = {}, this._plugins = {}, this._supress = {}, this._current = null, this._speed = null, this._coordinates = [], this._breakpoint = null, this._width = null, this._items = [], this._clones = [], this._mergers = [], this._widths = [], this._invalidated = {}, this._pipe = [], this._drag = {
        time: null,
        target: null,
        pointer: null,
        stage: {
          start: null,
          current: null
        },
        direction: null
      }, this._states = {
        current: {},
        tags: {
          initializing: ["busy"],
          animating: ["busy"],
          dragging: ["interacting"]
        }
      }, a.each(["onResize", "onThrottledResize"], a.proxy(function (b, c) {
        this._handlers[c] = a.proxy(this[c], this);
      }, this)), a.each(e.Plugins, a.proxy(function (a, b) {
        this._plugins[a.charAt(0).toLowerCase() + a.slice(1)] = new b(this);
      }, this)), a.each(e.Workers, a.proxy(function (b, c) {
        this._pipe.push({
          filter: c.filter,
          run: a.proxy(c.run, this)
        });
      }, this)), this.setup(), this.initialize();
    }
    e.Defaults = {
      items: 3,
      loop: !1,
      center: !1,
      rewind: !1,
      mouseDrag: !0,
      touchDrag: !0,
      pullDrag: !0,
      freeDrag: !1,
      margin: 0,
      stagePadding: 0,
      merge: !1,
      mergeFit: !0,
      autoWidth: !1,
      startPosition: 0,
      rtl: !1,
      smartSpeed: 250,
      fluidSpeed: !1,
      dragEndSpeed: !1,
      responsive: {},
      responsiveRefreshRate: 200,
      responsiveBaseElement: b,
      fallbackEasing: "swing",
      info: !1,
      nestedItemSelector: !1,
      itemElement: "div",
      stageElement: "div",
      refreshClass: "sby-owl-refresh",
      loadedClass: "sby-owl-loaded",
      loadingClass: "sby-owl-loading",
      rtlClass: "sby-owl-rtl",
      responsiveClass: "sby-owl-responsive",
      dragClass: "sby-owl-drag",
      itemClass: "sby-owl-item",
      stageClass: "sby-owl-stage",
      stageOuterClass: "sby-owl-stage-outer",
      grabClass: "sby-owl-grab"
    }, e.Width = {
      Default: "default",
      Inner: "inner",
      Outer: "outer"
    }, e.Type = {
      Event: "event",
      State: "state"
    }, e.Plugins = {}, e.Workers = [{
      filter: ["width", "settings"],
      run: function run() {
        this._width = this.$element.width();
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        a.current = this._items && this._items[this.relative(this._current)];
      }
    }, {
      filter: ["items", "settings"],
      run: function run() {
        this.$stage.children(".cloned").remove();
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = this.settings.margin || "",
          c = !this.settings.autoWidth,
          d = this.settings.rtl,
          e = {
            width: "auto",
            "margin-left": d ? b : "",
            "margin-right": d ? "" : b
          };
        !c && this.$stage.children().css(e), a.css = e;
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,
          c = null,
          d = this._items.length,
          e = !this.settings.autoWidth,
          f = [];
        for (a.items = {
          merge: !1,
          width: b
        }; d--;) c = this._mergers[d], c = this.settings.mergeFit && Math.min(c, this.settings.items) || c, a.items.merge = c > 1 || a.items.merge, f[d] = e ? b * c : this._items[d].width();
        this._widths = f;
      }
    }, {
      filter: ["items", "settings"],
      run: function run() {
        var b = [],
          c = this._items,
          d = this.settings,
          e = Math.max(2 * d.items, 4),
          f = 2 * Math.ceil(c.length / 2),
          g = d.loop && c.length ? d.rewind ? e : Math.max(e, f) : 0,
          h = "",
          i = "";
        for (g /= 2; g--;) b.push(this.normalize(b.length / 2, !0)), h += c[b[b.length - 1]][0].outerHTML, b.push(this.normalize(c.length - 1 - (b.length - 1) / 2, !0)), i = c[b[b.length - 1]][0].outerHTML + i;
        this._clones = b, a(h).addClass("cloned").appendTo(this.$stage), a(i).addClass("cloned").prependTo(this.$stage);
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run() {
        for (var a = this.settings.rtl ? 1 : -1, b = this._clones.length + this._items.length, c = -1, d = 0, e = 0, f = []; ++c < b;) d = f[c - 1] || 0, e = this._widths[this.relative(c)] + this.settings.margin, f.push(d + e * a);
        this._coordinates = f;
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run() {
        var a = this.settings.stagePadding,
          b = this._coordinates,
          c = {
            width: Math.ceil(Math.abs(b[b.length - 1])) + 2 * a,
            "padding-left": a || "",
            "padding-right": a || ""
          };
        this.$stage.css(c);
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = this._coordinates.length,
          c = !this.settings.autoWidth,
          d = this.$stage.children();
        if (c && a.items.merge) for (; b--;) a.css.width = this._widths[this.relative(b)], d.eq(b).css(a.css);else c && (a.css.width = a.items.width, d.css(a.css));
      }
    }, {
      filter: ["items"],
      run: function run() {
        this._coordinates.length < 1 && this.$stage.removeAttr("style");
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        a.current = a.current ? this.$stage.children().index(a.current) : 0, a.current = Math.max(this.minimum(), Math.min(this.maximum(), a.current)), this.reset(a.current);
      }
    }, {
      filter: ["position"],
      run: function run() {
        this.animate(this.coordinates(this._current));
      }
    }, {
      filter: ["width", "position", "items", "settings"],
      run: function run() {
        var a,
          b,
          c,
          d,
          e = this.settings.rtl ? 1 : -1,
          f = 2 * this.settings.stagePadding,
          g = this.coordinates(this.current()) + f,
          h = g + this.width() * e,
          i = [];
        for (c = 0, d = this._coordinates.length; c < d; c++) a = this._coordinates[c - 1] || 0, b = Math.abs(this._coordinates[c]) + f * e, (this.op(a, "<=", g) && this.op(a, ">", h) || this.op(b, "<", g) && this.op(b, ">", h)) && i.push(c);
        this.$stage.children(".active").removeClass("active"), this.$stage.children(":eq(" + i.join("), :eq(") + ")").addClass("active"), this.settings.center && (this.$stage.children(".center").removeClass("center"), this.$stage.children().eq(this.current()).addClass("center"));
      }
    }], e.prototype.initialize = function () {
      if (this.enter("initializing"), this.trigger("initialize"), this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl), this.settings.autoWidth && !this.is("pre-loading")) {
        var b, c, e;
        b = this.$element.find("img"), c = this.settings.nestedItemSelector ? "." + this.settings.nestedItemSelector : d, e = this.$element.children(c).width(), b.length && e <= 0 && this.preloadAutoWidthImages(b);
      }
      this.$element.addClass(this.options.loadingClass), this.$stage = a("<" + this.settings.stageElement + ' class="' + this.settings.stageClass + '"/>').wrap('<div class="' + this.settings.stageOuterClass + '"/>'), this.$element.append(this.$stage.parent()), this.replace(this.$element.children().not(this.$stage.parent())), this.$element.is(":visible") ? this.refresh() : this.invalidate("width"), this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass), this.registerEventHandlers(), this.leave("initializing"), this.trigger("initialized");
    }, e.prototype.setup = function () {
      var b = this.viewport(),
        c = this.options.responsive,
        d = -1,
        e = null;
      c ? (a.each(c, function (a) {
        a <= b && a > d && (d = Number(a));
      }), e = a.extend({}, this.options, c[d]), "function" == typeof e.stagePadding && (e.stagePadding = e.stagePadding()), delete e.responsive, e.responsiveClass && this.$element.attr("class", this.$element.attr("class").replace(new RegExp("(" + this.options.responsiveClass + "-)\\S+\\s", "g"), "$1" + d))) : e = a.extend({}, this.options), this.trigger("change", {
        property: {
          name: "settings",
          value: e
        }
      }), this._breakpoint = d, this.settings = e, this.invalidate("settings"), this.trigger("changed", {
        property: {
          name: "settings",
          value: this.settings
        }
      });
    }, e.prototype.optionsLogic = function () {
      this.settings.autoWidth && (this.settings.stagePadding = !1, this.settings.merge = !1);
    }, e.prototype.prepare = function (b) {
      var c = this.trigger("prepare", {
        content: b
      });
      return c.data || (c.data = a("<" + this.settings.itemElement + "/>").addClass(this.options.itemClass).append(b)), this.trigger("prepared", {
        content: c.data
      }), c.data;
    }, e.prototype.update = function () {
      for (var b = 0, c = this._pipe.length, d = a.proxy(function (a) {
          return this[a];
        }, this._invalidated), e = {}; b < c;) (this._invalidated.all || a.grep(this._pipe[b].filter, d).length > 0) && this._pipe[b].run(e), b++;
      this._invalidated = {}, !this.is("valid") && this.enter("valid");
    }, e.prototype.width = function (a) {
      switch (a = a || e.Width.Default) {
        case e.Width.Inner:
        case e.Width.Outer:
          return this._width;
        default:
          return this._width - 2 * this.settings.stagePadding + this.settings.margin;
      }
    }, e.prototype.refresh = function () {
      this.enter("refreshing"), this.trigger("refresh"), this.setup(), this.optionsLogic(), this.$element.addClass(this.options.refreshClass), this.update(), this.$element.removeClass(this.options.refreshClass), this.leave("refreshing"), this.trigger("refreshed");
    }, e.prototype.onThrottledResize = function () {
      b.clearTimeout(this.resizeTimer), this.resizeTimer = b.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);
    }, e.prototype.onResize = function () {
      return !!this._items.length && this._width !== this.$element.width() && !!this.$element.is(":visible") && (this.enter("resizing"), this.trigger("resize").isDefaultPrevented() ? (this.leave("resizing"), !1) : (this.invalidate("width"), this.refresh(), this.leave("resizing"), void this.trigger("resized")));
    }, e.prototype.registerEventHandlers = function () {
      a.support.transition && this.$stage.on(a.support.transition.end + ".owl.core", a.proxy(this.onTransitionEnd, this)), this.settings.responsive !== !1 && this.on(b, "resize", this._handlers.onThrottledResize), this.settings.mouseDrag && (this.$element.addClass(this.options.dragClass), this.$stage.on("mousedown.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("dragstart.owl.core selectstart.owl.core", function () {
        return !1;
      })), this.settings.touchDrag && (this.$stage.on("touchstart.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("touchcancel.owl.core", a.proxy(this.onDragEnd, this)));
    }, e.prototype.onDragStart = function (b) {
      var d = null;
      3 !== b.which && (a.support.transform ? (d = this.$stage.css("transform").replace(/.*\(|\)| /g, "").split(","), d = {
        x: d[16 === d.length ? 12 : 4],
        y: d[16 === d.length ? 13 : 5]
      }) : (d = this.$stage.position(), d = {
        x: this.settings.rtl ? d.left + this.$stage.width() - this.width() + this.settings.margin : d.left,
        y: d.top
      }), this.is("animating") && (a.support.transform ? this.animate(d.x) : this.$stage.stop(), this.invalidate("position")), this.$element.toggleClass(this.options.grabClass, "mousedown" === b.type), this.speed(0), this._drag.time = new Date().getTime(), this._drag.target = a(b.target), this._drag.stage.start = d, this._drag.stage.current = d, this._drag.pointer = this.pointer(b), a(c).on("mouseup.owl.core touchend.owl.core", a.proxy(this.onDragEnd, this)), a(c).one("mousemove.owl.core touchmove.owl.core", a.proxy(function (b) {
        var d = this.difference(this._drag.pointer, this.pointer(b));
        a(c).on("mousemove.owl.core touchmove.owl.core", a.proxy(this.onDragMove, this)), Math.abs(d.x) < Math.abs(d.y) && this.is("valid") || (b.preventDefault(), this.enter("dragging"), this.trigger("drag"));
      }, this)));
    }, e.prototype.onDragMove = function (a) {
      var b = null,
        c = null,
        d = null,
        e = this.difference(this._drag.pointer, this.pointer(a)),
        f = this.difference(this._drag.stage.start, e);
      this.is("dragging") && (a.preventDefault(), this.settings.loop ? (b = this.coordinates(this.minimum()), c = this.coordinates(this.maximum() + 1) - b, f.x = ((f.x - b) % c + c) % c + b) : (b = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum()), c = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum()), d = this.settings.pullDrag ? -1 * e.x / 5 : 0, f.x = Math.max(Math.min(f.x, b + d), c + d)), this._drag.stage.current = f, this.animate(f.x));
    }, e.prototype.onDragEnd = function (b) {
      var d = this.difference(this._drag.pointer, this.pointer(b)),
        e = this._drag.stage.current,
        f = d.x > 0 ^ this.settings.rtl ? "left" : "right";
      a(c).off(".owl.core"), this.$element.removeClass(this.options.grabClass), (0 !== d.x && this.is("dragging") || !this.is("valid")) && (this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed), this.current(this.closest(e.x, 0 !== d.x ? f : this._drag.direction)), this.invalidate("position"), this.update(), this._drag.direction = f, (Math.abs(d.x) > 3 || new Date().getTime() - this._drag.time > 300) && this._drag.target.one("click.owl.core", function () {
        return !1;
      })), this.is("dragging") && (this.leave("dragging"), this.trigger("dragged"));
    }, e.prototype.closest = function (b, c) {
      var d = -1,
        e = 30,
        f = this.width(),
        g = this.coordinates();
      return this.settings.freeDrag || a.each(g, a.proxy(function (a, h) {
        return "left" === c && b > h - e && b < h + e ? d = a : "right" === c && b > h - f - e && b < h - f + e ? d = a + 1 : this.op(b, "<", h) && this.op(b, ">", g[a + 1] || h - f) && (d = "left" === c ? a + 1 : a), d === -1;
      }, this)), this.settings.loop || (this.op(b, ">", g[this.minimum()]) ? d = b = this.minimum() : this.op(b, "<", g[this.maximum()]) && (d = b = this.maximum())), d;
    }, e.prototype.animate = function (b) {
      var c = this.speed() > 0;
      this.is("animating") && this.onTransitionEnd(), c && (this.enter("animating"), this.trigger("translate")), a.support.transform3d && a.support.transition ? this.$stage.css({
        transform: "translate3d(" + b + "px,0px,0px)",
        transition: this.speed() / 1e3 + "s"
      }) : c ? this.$stage.animate({
        left: b + "px"
      }, this.speed(), this.settings.fallbackEasing, a.proxy(this.onTransitionEnd, this)) : this.$stage.css({
        left: b + "px"
      });
    }, e.prototype.is = function (a) {
      return this._states.current[a] && this._states.current[a] > 0;
    }, e.prototype.current = function (a) {
      if (a === d) return this._current;
      if (0 === this._items.length) return d;
      if (a = this.normalize(a), this._current !== a) {
        var b = this.trigger("change", {
          property: {
            name: "position",
            value: a
          }
        });
        b.data !== d && (a = this.normalize(b.data)), this._current = a, this.invalidate("position"), this.trigger("changed", {
          property: {
            name: "position",
            value: this._current
          }
        });
      }
      return this._current;
    }, e.prototype.invalidate = function (b) {
      return "string" === a.type(b) && (this._invalidated[b] = !0, this.is("valid") && this.leave("valid")), a.map(this._invalidated, function (a, b) {
        return b;
      });
    }, e.prototype.reset = function (a) {
      a = this.normalize(a), a !== d && (this._speed = 0, this._current = a, this.suppress(["translate", "translated"]), this.animate(this.coordinates(a)), this.release(["translate", "translated"]));
    }, e.prototype.normalize = function (a, b) {
      var c = this._items.length,
        e = b ? 0 : this._clones.length;
      return !this.isNumeric(a) || c < 1 ? a = d : (a < 0 || a >= c + e) && (a = ((a - e / 2) % c + c) % c + e / 2), a;
    }, e.prototype.relative = function (a) {
      return a -= this._clones.length / 2, this.normalize(a, !0);
    }, e.prototype.maximum = function (a) {
      var b,
        c,
        d,
        e = this.settings,
        f = this._coordinates.length;
      if (e.loop) f = this._clones.length / 2 + this._items.length - 1;else if (e.autoWidth || e.merge) {
        for (b = this._items.length, c = this._items[--b].width(), d = this.$element.width(); b-- && (c += this._items[b].width() + this.settings.margin, !(c > d)););
        f = b + 1;
      } else f = e.center ? this._items.length - 1 : this._items.length - e.items;
      return a && (f -= this._clones.length / 2), Math.max(f, 0);
    }, e.prototype.minimum = function (a) {
      return a ? 0 : this._clones.length / 2;
    }, e.prototype.items = function (a) {
      return a === d ? this._items.slice() : (a = this.normalize(a, !0), this._items[a]);
    }, e.prototype.mergers = function (a) {
      return a === d ? this._mergers.slice() : (a = this.normalize(a, !0), this._mergers[a]);
    }, e.prototype.clones = function (b) {
      var c = this._clones.length / 2,
        e = c + this._items.length,
        f = function f(a) {
          return a % 2 === 0 ? e + a / 2 : c - (a + 1) / 2;
        };
      return b === d ? a.map(this._clones, function (a, b) {
        return f(b);
      }) : a.map(this._clones, function (a, c) {
        return a === b ? f(c) : null;
      });
    }, e.prototype.speed = function (a) {
      return a !== d && (this._speed = a), this._speed;
    }, e.prototype.coordinates = function (b) {
      var c,
        e = 1,
        f = b - 1;
      return b === d ? a.map(this._coordinates, a.proxy(function (a, b) {
        return this.coordinates(b);
      }, this)) : (this.settings.center ? (this.settings.rtl && (e = -1, f = b + 1), c = this._coordinates[b], c += (this.width() - c + (this._coordinates[f] || 0)) / 2 * e) : c = this._coordinates[f] || 0, c = Math.ceil(c));
    }, e.prototype.duration = function (a, b, c) {
      return 0 === c ? 0 : Math.min(Math.max(Math.abs(b - a), 1), 6) * Math.abs(c || this.settings.smartSpeed);
    }, e.prototype.to = function (a, b) {
      var c = this.current(),
        d = null,
        e = a - this.relative(c),
        f = (e > 0) - (e < 0),
        g = this._items.length,
        h = this.minimum(),
        i = this.maximum();
      this.settings.loop ? (!this.settings.rewind && Math.abs(e) > g / 2 && (e += f * -1 * g), a = c + e, d = ((a - h) % g + g) % g + h, d !== a && d - e <= i && d - e > 0 && (c = d - e, a = d, this.reset(c))) : this.settings.rewind ? (i += 1, a = (a % i + i) % i) : a = Math.max(h, Math.min(i, a)), this.speed(this.duration(c, a, b)), this.current(a), this.$element.is(":visible") && this.update();
    }, e.prototype.next = function (a) {
      a = a || !1, this.to(this.relative(this.current()) + 1, a);
    }, e.prototype.prev = function (a) {
      a = a || !1, this.to(this.relative(this.current()) - 1, a);
    }, e.prototype.onTransitionEnd = function (a) {
      if (a !== d && (a.stopPropagation(), (a.target || a.srcElement || a.originalTarget) !== this.$stage.get(0))) return !1;
      this.leave("animating"), this.trigger("translated");
    }, e.prototype.viewport = function () {
      var d;
      return this.options.responsiveBaseElement !== b ? d = a(this.options.responsiveBaseElement).width() : b.innerWidth ? d = b.innerWidth : c.documentElement && c.documentElement.clientWidth ? d = c.documentElement.clientWidth : console.warn("Can not detect viewport width."), d;
    }, e.prototype.replace = function (b) {
      this.$stage.empty(), this._items = [], b && (b = b instanceof jQuery ? b : a(b)), this.settings.nestedItemSelector && (b = b.find("." + this.settings.nestedItemSelector)), b.filter(function () {
        return 1 === this.nodeType;
      }).each(a.proxy(function (a, b) {
        b = this.prepare(b), this.$stage.append(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1);
      }, this)), this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0), this.invalidate("items");
    }, e.prototype.add = function (b, c) {
      var e = this.relative(this._current);
      c = c === d ? this._items.length : this.normalize(c, !0), b = b instanceof jQuery ? b : a(b), this.trigger("add", {
        content: b,
        position: c
      }), b = this.prepare(b), 0 === this._items.length || c === this._items.length ? (0 === this._items.length && this.$stage.append(b), 0 !== this._items.length && this._items[c - 1].after(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)) : (this._items[c].before(b), this._items.splice(c, 0, b), this._mergers.splice(c, 0, 1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)), this._items[e] && this.reset(this._items[e].index()), this.invalidate("items"), this.trigger("added", {
        content: b,
        position: c
      });
    }, e.prototype.remove = function (a) {
      a = this.normalize(a, !0), a !== d && (this.trigger("remove", {
        content: this._items[a],
        position: a
      }), this._items[a].remove(), this._items.splice(a, 1), this._mergers.splice(a, 1), this.invalidate("items"), this.trigger("removed", {
        content: null,
        position: a
      }));
    }, e.prototype.preloadAutoWidthImages = function (b) {
      b.each(a.proxy(function (b, c) {
        this.enter("pre-loading"), c = a(c), a(new Image()).one("load", a.proxy(function (a) {
          c.attr("src", a.target.src), c.css("opacity", 1), this.leave("pre-loading"), !this.is("pre-loading") && !this.is("initializing") && this.refresh();
        }, this)).attr("src", c.attr("src") || c.attr("data-src") || c.attr("data-src-retina"));
      }, this));
    }, e.prototype.destroy = function () {
      this.$element.off(".owl.core"), this.$stage.off(".owl.core"), a(c).off(".owl.core"), this.settings.responsive !== !1 && (b.clearTimeout(this.resizeTimer), this.off(b, "resize", this._handlers.onThrottledResize));
      for (var d in this._plugins) this._plugins[d].destroy();
      this.$stage.children(".cloned").remove(), this.$stage.unwrap(), this.$stage.children().contents().unwrap(), this.$stage.children().unwrap(), this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class", this.$element.attr("class").replace(new RegExp(this.options.responsiveClass + "-\\S+\\s", "g"), "")).removeData("owl.carousel");
    }, e.prototype.op = function (a, b, c) {
      var d = this.settings.rtl;
      switch (b) {
        case "<":
          return d ? a > c : a < c;
        case ">":
          return d ? a < c : a > c;
        case ">=":
          return d ? a <= c : a >= c;
        case "<=":
          return d ? a >= c : a <= c;
      }
    }, e.prototype.on = function (a, b, c, d) {
      a.addEventListener ? a.addEventListener(b, c, d) : a.attachEvent && a.attachEvent("on" + b, c);
    }, e.prototype.off = function (a, b, c, d) {
      a.removeEventListener ? a.removeEventListener(b, c, d) : a.detachEvent && a.detachEvent("on" + b, c);
    }, e.prototype.trigger = function (b, c, d, f, g) {
      var h = {
          item: {
            count: this._items.length,
            index: this.current()
          }
        },
        i = a.camelCase(a.grep(["on", b, d], function (a) {
          return a;
        }).join("-").toLowerCase()),
        j = a.Event([b, "owl", d || "carousel"].join(".").toLowerCase(), a.extend({
          relatedTarget: this
        }, h, c));
      return this._supress[b] || (a.each(this._plugins, function (a, b) {
        b.onTrigger && b.onTrigger(j);
      }), this.register({
        type: e.Type.Event,
        name: b
      }), this.$element.trigger(j), this.settings && "function" == typeof this.settings[i] && this.settings[i].call(this, j)), j;
    }, e.prototype.enter = function (b) {
      a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
        this._states.current[b] === d && (this._states.current[b] = 0), this._states.current[b]++;
      }, this));
    }, e.prototype.leave = function (b) {
      a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
        this._states.current[b]--;
      }, this));
    }, e.prototype.register = function (b) {
      if (b.type === e.Type.Event) {
        if (a.event.special[b.name] || (a.event.special[b.name] = {}), !a.event.special[b.name].owl) {
          var c = a.event.special[b.name]._default;
          a.event.special[b.name]._default = function (a) {
            return !c || !c.apply || a.namespace && a.namespace.indexOf("owl") !== -1 ? a.namespace && a.namespace.indexOf("owl") > -1 : c.apply(this, arguments);
          }, a.event.special[b.name].owl = !0;
        }
      } else b.type === e.Type.State && (this._states.tags[b.name] ? this._states.tags[b.name] = this._states.tags[b.name].concat(b.tags) : this._states.tags[b.name] = b.tags, this._states.tags[b.name] = a.grep(this._states.tags[b.name], a.proxy(function (c, d) {
        return a.inArray(c, this._states.tags[b.name]) === d;
      }, this)));
    }, e.prototype.suppress = function (b) {
      a.each(b, a.proxy(function (a, b) {
        this._supress[b] = !0;
      }, this));
    }, e.prototype.release = function (b) {
      a.each(b, a.proxy(function (a, b) {
        delete this._supress[b];
      }, this));
    }, e.prototype.pointer = function (a) {
      var c = {
        x: null,
        y: null
      };
      return a = a.originalEvent || a || b.event, a = a.touches && a.touches.length ? a.touches[0] : a.changedTouches && a.changedTouches.length ? a.changedTouches[0] : a, a.pageX ? (c.x = a.pageX, c.y = a.pageY) : (c.x = a.clientX, c.y = a.clientY), c;
    }, e.prototype.isNumeric = function (a) {
      return !isNaN(parseFloat(a));
    }, e.prototype.difference = function (a, b) {
      return {
        x: a.x - b.x,
        y: a.y - b.y
      };
    }, a.fn.sbyOwlCarousel = function (b) {
      var c = Array.prototype.slice.call(arguments, 1);
      return this.each(function () {
        var d = a(this),
          f = d.data("owl.carousel");
        f || (f = new e(this, "object" == _typeof(b) && b), d.data("owl.carousel", f), a.each(["next", "prev", "to", "destroy", "refresh", "replace", "add", "remove"], function (b, c) {
          f.register({
            type: e.Type.Event,
            name: c
          }), f.$element.on(c + ".owl.carousel.core", a.proxy(function (a) {
            a.namespace && a.relatedTarget !== this && (this.suppress([c]), f[c].apply(this, [].slice.call(arguments, 1)), this.release([c]));
          }, f));
        })), "string" == typeof b && "_" !== b.charAt(0) && f[b].apply(f, c);
      });
    }, a.fn.sbyOwlCarousel.Constructor = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e = function e(b) {
      this._core = b, this._interval = null, this._visible = null, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoRefresh && this.watch();
        }, this)
      }, this._core.options = a.extend({}, _e.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    _e.Defaults = {
      autoRefresh: !0,
      autoRefreshInterval: 500
    }, _e.prototype.watch = function () {
      this._interval || (this._visible = this._core.$element.is(":visible"), this._interval = b.setInterval(a.proxy(this.refresh, this), this._core.settings.autoRefreshInterval));
    }, _e.prototype.refresh = function () {
      this._core.$element.is(":visible") !== this._visible && (this._visible = !this._visible, this._core.$element.toggleClass("sby-owl-hidden", !this._visible), this._visible && this._core.invalidate("width") && this._core.refresh());
    }, _e.prototype.destroy = function () {
      var a, c;
      b.clearInterval(this._interval);
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.AutoRefresh = _e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e2 = function e(b) {
      this._core = b, this._loaded = [], this._handlers = {
        "initialized.owl.carousel change.owl.carousel resized.owl.carousel": a.proxy(function (b) {
          if (b.namespace && this._core.settings && this._core.settings.lazyLoad && (b.property && "position" == b.property.name || "initialized" == b.type)) for (var c = this._core.settings, e = c.center && Math.ceil(c.items / 2) || c.items, f = c.center && e * -1 || 0, g = (b.property && b.property.value !== d ? b.property.value : this._core.current()) + f, h = this._core.clones().length, i = a.proxy(function (a, b) {
              this.load(b);
            }, this); f++ < e;) this.load(h / 2 + this._core.relative(g)), h && a.each(this._core.clones(this._core.relative(g)), i), g++;
        }, this)
      }, this._core.options = a.extend({}, _e2.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    _e2.Defaults = {
      lazyLoad: !1
    }, _e2.prototype.load = function (c) {
      var d = this._core.$stage.children().eq(c),
        e = d && d.find(".sby-owl-lazy");
      !e || a.inArray(d.get(0), this._loaded) > -1 || (e.each(a.proxy(function (c, d) {
        var e,
          f = a(d),
          g = b.devicePixelRatio > 1 && f.attr("data-src-retina") || f.attr("data-src");
        this._core.trigger("load", {
          element: f,
          url: g
        }, "lazy"), f.is("img") ? f.one("load.owl.lazy", a.proxy(function () {
          f.css("opacity", 1), this._core.trigger("loaded", {
            element: f,
            url: g
          }, "lazy");
        }, this)).attr("src", g) : (e = new Image(), e.onload = a.proxy(function () {
          f.css({
            "background-image": 'url("' + g + '")',
            opacity: "1"
          }), this._core.trigger("loaded", {
            element: f,
            url: g
          }, "lazy");
        }, this), e.src = g);
      }, this)), this._loaded.push(d.get(0)));
    }, _e2.prototype.destroy = function () {
      var a, b;
      for (a in this.handlers) this._core.$element.off(a, this.handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Lazy = _e2;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e3 = function e(b) {
      this._core = b, this._handlers = {
        "initialized.owl.carousel refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && this.update();
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && "position" == a.property.name && this.update();
        }, this),
        "loaded.owl.lazy": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && a.element.closest("." + this._core.settings.itemClass).index() === this._core.current() && this.update();
        }, this)
      }, this._core.options = a.extend({}, _e3.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    _e3.Defaults = {
      autoHeight: !1,
      autoHeightClass: "sby-owl-height"
    }, _e3.prototype.update = function () {
      var b = this._core._current,
        c = b + this._core.settings.items,
        d = this._core.$stage.children().toArray().slice(b, c),
        e = [],
        f = 0;
      a.each(d, function (b, c) {
        e.push(a(c).height());
      }), f = Math.max.apply(null, e), this._core.$stage.parent().height(f).addClass(this._core.settings.autoHeightClass);
    }, _e3.prototype.destroy = function () {
      var a, b;
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.AutoHeight = _e3;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e4 = function e(b) {
      this._core = b, this._videos = {}, this._playing = null, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.register({
            type: "state",
            name: "playing",
            tags: ["interacting"]
          });
        }, this),
        "resize.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.video && this.isInFullScreen() && a.preventDefault();
        }, this),
        "refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.is("resizing") && this._core.$stage.find(".cloned .sby-owl-video-frame").remove();
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" === a.property.name && this._playing && this.stop();
        }, this),
        "prepared.owl.carousel": a.proxy(function (b) {
          if (b.namespace) {
            var c = a(b.content).find(".sby-owl-video");
            c.length && (c.css("display", "none"), this.fetch(c, a(b.content)));
          }
        }, this)
      }, this._core.options = a.extend({}, _e4.Defaults, this._core.options), this._core.$element.on(this._handlers), this._core.$element.on("click.owl.video", ".sby-owl-video-play-icon", a.proxy(function (a) {
        this.play(a);
      }, this));
    };
    _e4.Defaults = {
      video: !1,
      videoHeight: !1,
      videoWidth: !1
    }, _e4.prototype.fetch = function (a, b) {
      var c = function () {
          return a.attr("data-vimeo-id") ? "vimeo" : a.attr("data-vzaar-id") ? "vzaar" : "youtube";
        }(),
        d = a.attr("data-vimeo-id") || a.attr("data-youtube-id") || a.attr("data-vzaar-id"),
        e = a.attr("data-width") || this._core.settings.videoWidth,
        f = a.attr("data-height") || this._core.settings.videoHeight,
        g = a.attr("href");
      if (!g) throw new Error("Missing video URL.");
      if (d = g.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/), d[3].indexOf("youtu") > -1) c = "youtube";else if (d[3].indexOf("vimeo") > -1) c = "vimeo";else {
        if (!(d[3].indexOf("vzaar") > -1)) throw new Error("Video URL not supported.");
        c = "vzaar";
      }
      d = d[6], this._videos[g] = {
        type: c,
        id: d,
        width: e,
        height: f
      }, b.attr("data-video", g), this.thumbnail(a, this._videos[g]);
    }, _e4.prototype.thumbnail = function (b, c) {
      var d,
        e,
        f,
        g = c.width && c.height ? 'style="width:' + c.width + "px;height:" + c.height + 'px;"' : "",
        h = b.find("img"),
        i = "src",
        j = "",
        k = this._core.settings,
        l = function l(a) {
          e = '<div class="sby-owl-video-play-icon"></div>', d = k.lazyLoad ? '<div class="sby-owl-video-tn ' + j + '" ' + i + '="' + a + '"></div>' : '<div class="sby-owl-video-tn" style="opacity:1;background-image:url(' + a + ')"></div>', b.after(d), b.after(e);
        };
      if (b.wrap('<div class="sby-owl-video-wrapper"' + g + "></div>"), this._core.settings.lazyLoad && (i = "data-src", j = "sby-owl-lazy"), h.length) return l(h.attr(i)), h.remove(), !1;
      "youtube" === c.type ? (f = "//img.youtube.com/vi/" + c.id + "/hqdefault.jpg", l(f)) : "vimeo" === c.type ? a.ajax({
        type: "GET",
        url: "//vimeo.com/api/v2/video/" + c.id + ".json",
        jsonp: "callback",
        dataType: "jsonp",
        success: function success(a) {
          f = a[0].thumbnail_large, l(f);
        }
      }) : "vzaar" === c.type && a.ajax({
        type: "GET",
        url: "//vzaar.com/api/videos/" + c.id + ".json",
        jsonp: "callback",
        dataType: "jsonp",
        success: function success(a) {
          f = a.framegrab_url, l(f);
        }
      });
    }, _e4.prototype.stop = function () {
      this._core.trigger("stop", null, "video"), this._playing.find(".sby-owl-video-frame").remove(), this._playing.removeClass("sby-owl-video-playing"), this._playing = null, this._core.leave("playing"), this._core.trigger("stopped", null, "video");
    }, _e4.prototype.play = function (b) {
      var c,
        d = a(b.target),
        e = d.closest("." + this._core.settings.itemClass),
        f = this._videos[e.attr("data-video")],
        g = f.width || "100%",
        h = f.height || this._core.$stage.height();
      this._playing || (this._core.enter("playing"), this._core.trigger("play", null, "video"), e = this._core.items(this._core.relative(e.index())), this._core.reset(e.index()), "youtube" === f.type ? c = '<iframe width="' + g + '" height="' + h + '" src="//www.youtube.com/embed/' + f.id + "?autoplay=1&rel=0&v=" + f.id + '" frameborder="0" allowfullscreen></iframe>' : "vimeo" === f.type ? c = '<iframe src="//player.vimeo.com/video/' + f.id + '?autoplay=1" width="' + g + '" height="' + h + '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>' : "vzaar" === f.type && (c = '<iframe frameborder="0"height="' + h + '"width="' + g + '" allowfullscreen mozallowfullscreen webkitAllowFullScreen src="//view.vzaar.com/' + f.id + '/player?autoplay=true"></iframe>'), a('<div class="sby-owl-video-frame">' + c + "</div>").insertAfter(e.find(".sby-owl-video")), this._playing = e.addClass("sby-owl-video-playing"));
    }, _e4.prototype.isInFullScreen = function () {
      var b = c.fullscreenElement || c.mozFullScreenElement || c.webkitFullscreenElement;
      return b && a(b).parent().hasClass("sby-owl-video-frame");
    }, _e4.prototype.destroy = function () {
      var a, b;
      this._core.$element.off("click.owl.video");
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Video = _e4;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e5 = function e(b) {
      this.core = b, this.core.options = a.extend({}, _e5.Defaults, this.core.options), this.swapping = !0, this.previous = d, this.next = d, this.handlers = {
        "change.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" == a.property.name && (this.previous = this.core.current(), this.next = a.property.value);
        }, this),
        "drag.owl.carousel dragged.owl.carousel translated.owl.carousel": a.proxy(function (a) {
          a.namespace && (this.swapping = "translated" == a.type);
        }, this),
        "translate.owl.carousel": a.proxy(function (a) {
          a.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn) && this.swap();
        }, this)
      }, this.core.$element.on(this.handlers);
    };
    _e5.Defaults = {
      animateOut: !1,
      animateIn: !1
    }, _e5.prototype.swap = function () {
      if (1 === this.core.settings.items && a.support.animation && a.support.transition) {
        this.core.speed(0);
        var b,
          c = a.proxy(this.clear, this),
          d = this.core.$stage.children().eq(this.previous),
          e = this.core.$stage.children().eq(this.next),
          f = this.core.settings.animateIn,
          g = this.core.settings.animateOut;
        this.core.current() !== this.previous && (g && (b = this.core.coordinates(this.previous) - this.core.coordinates(this.next), d.one(a.support.animation.end, c).css({
          left: b + "px"
        }).addClass("animated sby-owl-animated-out").addClass(g)), f && e.one(a.support.animation.end, c).addClass("animated sby-owl-animated-in").addClass(f));
      }
    }, _e5.prototype.clear = function (b) {
      a(b.target).css({
        left: ""
      }).removeClass("animated sby-owl-animated-out sby-owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut), this.core.onTransitionEnd();
    }, _e5.prototype.destroy = function () {
      var a, b;
      for (a in this.handlers) this.core.$element.off(a, this.handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Animate = _e5;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var _e6 = function e(b) {
      this._core = b, this._timeout = null, this._paused = !1, this._handlers = {
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "settings" === a.property.name ? this._core.settings.autoplay ? this.play() : this.stop() : a.namespace && "position" === a.property.name && this._core.settings.autoplay && this._setAutoPlayInterval();
        }, this),
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoplay && this.play();
        }, this),
        "play.owl.autoplay": a.proxy(function (a, b, c) {
          a.namespace && this.play(b, c);
        }, this),
        "stop.owl.autoplay": a.proxy(function (a) {
          a.namespace && this.stop();
        }, this),
        "mouseover.owl.autoplay": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
        }, this),
        "mouseleave.owl.autoplay": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.play();
        }, this),
        "touchstart.owl.core": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
        }, this),
        "touchend.owl.core": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this.play();
        }, this)
      }, this._core.$element.on(this._handlers), this._core.options = a.extend({}, _e6.Defaults, this._core.options);
    };
    _e6.Defaults = {
      autoplay: !1,
      autoplayTimeout: 5e3,
      autoplayHoverPause: !1,
      autoplaySpeed: !1
    }, _e6.prototype.play = function (a, b) {
      this._paused = !1, this._core.is("rotating") || (this._core.enter("rotating"), this._setAutoPlayInterval());
    }, _e6.prototype._getNextTimeout = function (d, e) {
      return this._timeout && b.clearTimeout(this._timeout), b.setTimeout(a.proxy(function () {
        this._paused || this._core.is("busy") || this._core.is("interacting") || c.hidden || this._core.next(e || this._core.settings.autoplaySpeed);
      }, this), d || this._core.settings.autoplayTimeout);
    }, _e6.prototype._setAutoPlayInterval = function () {
      this._timeout = this._getNextTimeout();
    }, _e6.prototype.stop = function () {
      this._core.is("rotating") && (b.clearTimeout(this._timeout), this._core.leave("rotating"));
    }, _e6.prototype.pause = function () {
      this._core.is("rotating") && (this._paused = !0);
    }, _e6.prototype.destroy = function () {
      var a, b;
      this.stop();
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.autoplay = _e6;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    "use strict";

    var _e7 = function e(b) {
      this._core = b, this._initialized = !1, this._pages = [], this._controls = {}, this._templates = [], this.$element = this._core.$element, this._overrides = {
        next: this._core.next,
        prev: this._core.prev,
        to: this._core.to
      }, this._handlers = {
        "prepared.owl.carousel": a.proxy(function (b) {
          b.namespace && this._core.settings.dotsData && this._templates.push('<div class="' + this._core.settings.dotClass + '">' + a(b.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot") + "</div>");
        }, this),
        "added.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 0, this._templates.pop());
        }, this),
        "remove.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 1);
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" == a.property.name && this.draw();
        }, this),
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && !this._initialized && (this._core.trigger("initialize", null, "navigation"), this.initialize(), this.update(), this.draw(), this._initialized = !0, this._core.trigger("initialized", null, "navigation"));
        }, this),
        "refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._initialized && (this._core.trigger("refresh", null, "navigation"), this.update(), this.draw(), this._core.trigger("refreshed", null, "navigation"));
        }, this)
      }, this._core.options = a.extend({}, _e7.Defaults, this._core.options), this.$element.on(this._handlers);
    };
    _e7.Defaults = {
      nav: !1,
      navText: ["prev", "next"],
      navSpeed: !1,
      navElement: "div",
      navContainer: !1,
      navContainerClass: "sby-owl-nav",
      navClass: ["sby-owl-prev", "sby-owl-next"],
      slideBy: 1,
      dotClass: "sby-owl-dot",
      dotsClass: "sby-owl-dots",
      dots: !0,
      dotsEach: !1,
      dotsData: !1,
      dotsSpeed: !1,
      dotsContainer: !1
    }, _e7.prototype.initialize = function () {
      var b,
        c = this._core.settings;
      this._controls.$relative = (c.navContainer ? a(c.navContainer) : a("<div>").addClass(c.navContainerClass).appendTo(this.$element)).addClass("disabled"), this._controls.$previous = a("<" + c.navElement + ">").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on("click", a.proxy(function (a) {
        this.prev(c.navSpeed);
      }, this)), this._controls.$next = a("<" + c.navElement + ">").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on("click", a.proxy(function (a) {
        this.next(c.navSpeed);
      }, this)), c.dotsData || (this._templates = [a("<div>").addClass(c.dotClass).append(a("<span>")).prop("outerHTML")]), this._controls.$absolute = (c.dotsContainer ? a(c.dotsContainer) : a("<div>").addClass(c.dotsClass).appendTo(this.$element)).addClass("disabled"), this._controls.$absolute.on("click", "div", a.proxy(function (b) {
        var d = a(b.target).parent().is(this._controls.$absolute) ? a(b.target).index() : a(b.target).parent().index();
        b.preventDefault(), this.to(d, c.dotsSpeed);
      }, this));
      for (b in this._overrides) this._core[b] = a.proxy(this[b], this);
    }, _e7.prototype.destroy = function () {
      var a, b, c, d;
      for (a in this._handlers) this.$element.off(a, this._handlers[a]);
      for (b in this._controls) this._controls[b].remove();
      for (d in this.overides) this._core[d] = this._overrides[d];
      for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
    }, _e7.prototype.update = function () {
      var a,
        b,
        c,
        d = this._core.clones().length / 2,
        e = d + this._core.items().length,
        f = this._core.maximum(!0),
        g = this._core.settings,
        h = g.center || g.autoWidth || g.dotsData ? 1 : g.dotsEach || g.items;
      if ("page" !== g.slideBy && (g.slideBy = Math.min(g.slideBy, g.items)), g.dots || "page" == g.slideBy) for (this._pages = [], a = d, b = 0, c = 0; a < e; a++) {
        if (b >= h || 0 === b) {
          if (this._pages.push({
            start: Math.min(f, a - d),
            end: a - d + h - 1
          }), Math.min(f, a - d) === f) break;
          b = 0, ++c;
        }
        b += this._core.mergers(this._core.relative(a));
      }
    }, _e7.prototype.draw = function () {
      var b,
        c = this._core.settings,
        d = this._core.items().length <= c.items,
        e = this._core.relative(this._core.current()),
        f = c.loop || c.rewind;
      this._controls.$relative.toggleClass("disabled", !c.nav || d), c.nav && (this._controls.$previous.toggleClass("disabled", !f && e <= this._core.minimum(!0)), this._controls.$next.toggleClass("disabled", !f && e >= this._core.maximum(!0))), this._controls.$absolute.toggleClass("disabled", !c.dots || d), c.dots && (b = this._pages.length - this._controls.$absolute.children().length, c.dotsData && 0 !== b ? this._controls.$absolute.html(this._templates.join("")) : b > 0 ? this._controls.$absolute.append(new Array(b + 1).join(this._templates[0])) : b < 0 && this._controls.$absolute.children().slice(b).remove(), this._controls.$absolute.find(".active").removeClass("active"), this._controls.$absolute.children().eq(a.inArray(this.current(), this._pages)).addClass("active"));
    }, _e7.prototype.onTrigger = function (b) {
      var c = this._core.settings;
      b.page = {
        index: a.inArray(this.current(), this._pages),
        count: this._pages.length,
        size: c && (c.center || c.autoWidth || c.dotsData ? 1 : c.dotsEach || c.items)
      };
    }, _e7.prototype.current = function () {
      var b = this._core.relative(this._core.current());
      return a.grep(this._pages, a.proxy(function (a, c) {
        return a.start <= b && a.end >= b;
      }, this)).pop();
    }, _e7.prototype.getPosition = function (b) {
      var c,
        d,
        e = this._core.settings;
      return "page" == e.slideBy ? (c = a.inArray(this.current(), this._pages), d = this._pages.length, b ? ++c : --c, c = this._pages[(c % d + d) % d].start) : (c = this._core.relative(this._core.current()), d = this._core.items().length, b ? c += e.slideBy : c -= e.slideBy), c;
    }, _e7.prototype.next = function (b) {
      a.proxy(this._overrides.to, this._core)(this.getPosition(!0), b);
    }, _e7.prototype.prev = function (b) {
      a.proxy(this._overrides.to, this._core)(this.getPosition(!1), b);
    }, _e7.prototype.to = function (b, c, d) {
      var e;
      !d && this._pages.length ? (e = this._pages.length, a.proxy(this._overrides.to, this._core)(this._pages[(b % e + e) % e].start, c)) : a.proxy(this._overrides.to, this._core)(b, c);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Navigation = _e7;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    "use strict";

    var _e8 = function e(c) {
      this._core = c, this._hashes = {}, this.$element = this._core.$element, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (c) {
          c.namespace && "URLHash" === this._core.settings.startPosition && a(b).trigger("hashchange.owl.navigation");
        }, this),
        "prepared.owl.carousel": a.proxy(function (b) {
          if (b.namespace) {
            var c = a(b.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");
            if (!c) return;
            this._hashes[c] = b.content;
          }
        }, this),
        "changed.owl.carousel": a.proxy(function (c) {
          if (c.namespace && "position" === c.property.name) {
            var d = this._core.items(this._core.relative(this._core.current())),
              e = a.map(this._hashes, function (a, b) {
                return a === d ? b : null;
              }).join();
            if (!e || b.location.hash.slice(1) === e) return;
            b.location.hash = e;
          }
        }, this)
      }, this._core.options = a.extend({}, _e8.Defaults, this._core.options), this.$element.on(this._handlers), a(b).on("hashchange.owl.navigation", a.proxy(function (a) {
        var c = b.location.hash.substring(1),
          e = this._core.$stage.children(),
          f = this._hashes[c] && e.index(this._hashes[c]);
        f !== d && f !== this._core.current() && this._core.to(this._core.relative(f), !1, !0);
      }, this));
    };
    _e8.Defaults = {
      URLhashListener: !1
    }, _e8.prototype.destroy = function () {
      var c, d;
      a(b).off("hashchange.owl.navigation");
      for (c in this._handlers) this._core.$element.off(c, this._handlers[c]);
      for (d in Object.getOwnPropertyNames(this)) "function" != typeof this[d] && (this[d] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Hash = _e8;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    function e(b, c) {
      var e = !1,
        f = b.charAt(0).toUpperCase() + b.slice(1);
      return a.each((b + " " + h.join(f + " ") + f).split(" "), function (a, b) {
        if (g[b] !== d) return e = !c || b, !1;
      }), e;
    }
    function f(a) {
      return e(a, !0);
    }
    var g = a("<support>").get(0).style,
      h = "Webkit Moz O ms".split(" "),
      i = {
        transition: {
          end: {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            transition: "transitionend"
          }
        },
        animation: {
          end: {
            WebkitAnimation: "webkitAnimationEnd",
            MozAnimation: "animationend",
            OAnimation: "oAnimationEnd",
            animation: "animationend"
          }
        }
      },
      j = {
        csstransforms: function csstransforms() {
          return !!e("transform");
        },
        csstransforms3d: function csstransforms3d() {
          return !!e("perspective");
        },
        csstransitions: function csstransitions() {
          return !!e("transition");
        },
        cssanimations: function cssanimations() {
          return !!e("animation");
        }
      };
    j.csstransitions() && (a.support.transition = new String(f("transition")), a.support.transition.end = i.transition.end[a.support.transition]), j.cssanimations() && (a.support.animation = new String(f("animation")), a.support.animation.end = i.animation.end[a.support.animation]), j.csstransforms() && (a.support.transform = new String(f("transform")), a.support.transform3d = j.csstransforms3d());
  }(window.Zepto || window.jQuery, window, document);

  // Two Row Carousel
  ;
  (function ($, window, document, undefined) {
    Owl2row = function (_Owl2row) {
      function Owl2row(_x) {
        return _Owl2row.apply(this, arguments);
      }
      Owl2row.toString = function () {
        return _Owl2row.toString();
      };
      return Owl2row;
    }(function (scope) {
      this.owl = scope;
      this.owl.options = $.extend({}, Owl2row.Defaults, this.owl.options);
      //link callback events with owl carousel here

      this.handlers = {
        'initialize.owl.carousel': $.proxy(function (e) {
          if (this.owl.settings.owl2row) {
            this.build2row(this);
          }
        }, this)
      };
      this.owl.$element.on(this.handlers);
    });
    Owl2row.Defaults = {
      owl2row: false,
      owl2rowTarget: 'sby_item',
      owl2rowContainer: 'sby_owl2row-item',
      owl2rowDirection: 'utd' // ltr
    };

    //mehtods:
    Owl2row.prototype.build2row = function (thisScope) {
      var carousel = $(thisScope.owl.$element);
      var carouselItems = carousel.find('.' + thisScope.owl.options.owl2rowTarget);
      var aEvenElements = [];
      var aOddElements = [];
      $.each(carouselItems, function (index, item) {
        if (index % 2 === 0) {
          aEvenElements.push(item);
        } else {
          aOddElements.push(item);
        }
      });

      //carousel.empty();

      switch (thisScope.owl.options.owl2rowDirection) {
        case 'ltr':
          thisScope.leftToright(thisScope, carousel, carouselItems);
          break;
        default:
          thisScope.upTodown(thisScope, aEvenElements, aOddElements, carousel);
      }
    };
    Owl2row.prototype.leftToright = function (thisScope, carousel, carouselItems) {
      var o2wContainerClass = thisScope.owl.options.owl2rowContainer;
      var owlMargin = thisScope.owl.options.margin;
      var carouselItemsLength = carouselItems.length;
      var firsArr = [];
      var secondArr = [];
      if (carouselItemsLength % 2 === 1) {
        carouselItemsLength = (carouselItemsLength - 1) / 2 + 1;
      } else {
        carouselItemsLength = carouselItemsLength / 2;
      }
      $.each(carouselItems, function (index, item) {
        if (index < carouselItemsLength) {
          firsArr.push(item);
        } else {
          secondArr.push(item);
        }
      });
      $.each(firsArr, function (index, item) {
        var rowContainer = $('<div class="' + o2wContainerClass + '"/>');
        var firstRowElement = firsArr[index];
        firstRowElement.style.marginBottom = owlMargin + 'px';
        rowContainer.append(firstRowElement).append(secondArr[index]);
        carousel.append(rowContainer);
      });
    };
    Owl2row.prototype.upTodown = function (thisScope, aEvenElements, aOddElements, carousel) {
      var o2wContainerClass = thisScope.owl.options.owl2rowContainer;
      var owlMargin = thisScope.owl.options.margin;
      $.each(aEvenElements, function (index, item) {
        var rowContainer = $('<div class="' + o2wContainerClass + '"/>');
        var evenElement = aEvenElements[index];
        evenElement.style.marginBottom = owlMargin + 'px';
        rowContainer.append(evenElement).append(aOddElements[index]);
        carousel.append(rowContainer);
      });
    };

    /**
     * Destroys the plugin.
     */
    Owl2row.prototype.destroy = function () {
      var handler, property;
    };
    $.fn.sbyOwlCarousel.Constructor.Plugins['owl2row'] = Owl2row;
  })(window.Zepto || window.jQuery, window, document);
  (function ($) {
    function sbyAddVisibilityListener() {
      /* Detect when element becomes visible. Used for when the feed is initially hidden, in a tab for example. https://github.com/shaunbowe/jquery.visibilityChanged */
      !function (i) {
        var n = {
            callback: function callback() {},
            runOnLoad: !0,
            frequency: 100,
            sbyPreviousVisibility: null
          },
          c = {};
        c.sbyCheckVisibility = function (i, n) {
          if (jQuery.contains(document, i[0])) {
            var e = n.sbyPreviousVisibility,
              t = i.is(":visible");
            n.sbyPreviousVisibility = t, null == e ? n.runOnLoad && n.callback(i, t) : e !== t && n.callback(i, t), setTimeout(function () {
              c.sbyCheckVisibility(i, n);
            }, n.frequency);
          }
        }, i.fn.sbyVisibilityChanged = function (e) {
          var t = i.extend({}, n, e);
          return this.each(function () {
            c.sbyCheckVisibility(i(this), t);
          });
        };
      }(jQuery);
    }
    function Sby() {
      this.feeds = {};
      this.ctas = {};
      this.options = sbyOptions;
      this.isTouch = sbyIsTouch();
    }
    Sby.prototype = {
      createPage: function createPage(createFeeds, createFeedsArgs) {
        if (typeof window.sbyajaxurl === 'undefined' || window.sbyajaxurl.indexOf(window.location.hostname) === -1) {
          window.sbyajaxurl = window.location.hostname + '/wp-admin/admin-ajax.php';
        }
        $('.sby_no_js_error_message').remove();
        $('.sby_no_js').removeClass('sby_no_js');
        createFeeds(createFeedsArgs);
      },
      maybeAddYTAPI: function maybeAddYTAPI() {
        var youtubeScriptId = "sby-youtube-api";
        var youtubeScript = document.getElementById(youtubeScriptId);
        if (youtubeScript === null) {
          var tag = document.createElement("script");
          var firstScript = document.getElementsByTagName("script")[0];
          tag.src = "https://www.youtube.com/iframe_api";
          tag.id = youtubeScriptId;
          firstScript.parentNode.insertBefore(tag, firstScript);
        }
      },
      createLightbox: function createLightbox() {
        var lbBuilder = sbyGetlightboxBuilder();
        var sby_lb_delay = function () {
          var sby_timer = 0;
          return function (sby_callback, sby_ms) {
            clearTimeout(sby_timer);
            sby_timer = setTimeout(sby_callback, sby_ms);
          };
        }();
        jQuery(window).on('resize', function () {
          sby_lb_delay(function () {
            lbBuilder.afterResize();
          }, 200);
        });
        /* Lightbox v2.7.1 by Lokesh Dhakar - http://lokeshdhakar.com/projects/lightbox2/ - Heavily modified specifically for this plugin */
        (function () {
          var a = jQuery,
            b = function () {
              function a() {
                this.fadeDuration = 500, this.fitImagesInViewport = !0, this.resizeDuration = 700, this.positionFromTop = 50, this.showImageNumberLabel = !0, this.alwaysShowNavOnTouchDevices = !1, this.wrapAround = !1;
              }
              return a.prototype.albumLabel = function (a, b) {
                return a + " / " + b;
              }, a;
            }(),
            c = function () {
              function b(a) {
                this.options = a, this.album = [], this.currentImageIndex = void 0, this.init();
              }
              return b.prototype.init = function () {
                this.enable(), this.build();
              }, b.prototype.enable = function () {
                var b = this;
                a("body").on("click", "a[data-sby-lightbox]", function (c) {
                  return b.start(a(c.currentTarget)), !1;
                });
              }, b.prototype.build = function () {
                var b = this;
                a("" + lbBuilder.template()).appendTo(a("body")), this.$lightbox = a("#sby_lightbox"), this.$overlay = a("#sby_lightboxOverlay"), this.$outerContainer = this.$lightbox.find(".sby_lb-outerContainer"), this.$container = this.$lightbox.find(".sby_lb-container"), this.containerTopPadding = parseInt(this.$container.css("padding-top"), 10), this.containerRightPadding = parseInt(this.$container.css("padding-right"), 10), this.containerBottomPadding = parseInt(this.$container.css("padding-bottom"), 10), this.containerLeftPadding = parseInt(this.$container.css("padding-left"), 10), this.$overlay.hide().on("click", function () {
                  return b.end(), !1;
                }), jQuery(document).on('click', function (event, b, c) {
                  //Fade out the lightbox if click anywhere outside of the two elements defined below
                  if (!jQuery(event.target).closest('.sby_lb-outerContainer').length) {
                    if (!jQuery(event.target).closest('.sby_lb-dataContainer').length) {
                      //Fade out lightbox
                      lightboxOnClose();
                      lbBuilder.pausePlayer();
                      jQuery('#sby_lightboxOverlay, #sby_lightbox').fadeOut();
                    }
                  }
                }), this.$lightbox.hide(), jQuery('#sby_lightboxOverlay').on("click", function (c) {
                  lbBuilder.pausePlayer();
                  return "sby_lightbox" === a(c.target).attr("id") && b.end(), !1;
                }), this.$lightbox.find(".sby_lb-prev").on("click", function () {
                  lbBuilder.pausePlayer();
                  return b.changeImage(0 === b.currentImageIndex ? b.album.length - 1 : b.currentImageIndex - 1), !1;
                }), this.$lightbox.find(".sby_lb-container").on("swiperight", function () {
                  lbBuilder.pausePlayer();
                  return b.changeImage(0 === b.currentImageIndex ? b.album.length - 1 : b.currentImageIndex - 1), !1;
                }), this.$lightbox.find(".sby_lb-next").on("click", function () {
                  lbBuilder.pausePlayer();
                  return b.changeImage(b.currentImageIndex === b.album.length - 1 ? 0 : b.currentImageIndex + 1), !1;
                }), this.$lightbox.find(".sby_lb-container").on("swipeleft", function () {
                  lbBuilder.pausePlayer();
                  return b.changeImage(b.currentImageIndex === b.album.length - 1 ? 0 : b.currentImageIndex + 1), !1;
                }), this.$lightbox.find(".sby_lb-loader, .sby_lb-close").on("click", function () {
                  lightboxOnClose();
                  lbBuilder.pausePlayer();
                  return b.end(), !1;
                });
              }, b.prototype.start = function (b) {
                function c(a) {
                  d.album.push(lbBuilder.getData(a));
                }
                var d = this,
                  e = a(window);
                e.on("resize", a.proxy(this.sizeOverlay, this)), a("select, object, embed").css({
                  visibility: "hidden"
                }), this.sizeOverlay(), this.album = [];
                var f,
                  g = 0,
                  h = b.attr("data-sby-lightbox");
                if (h) {
                  f = a(b.prop("tagName") + '[data-sby-lightbox="' + h + '"]');
                  for (var i = 0; i < f.length; i = ++i) c(a(f[i])), f[i] === b[0] && (g = i);
                } else if ("lightbox" === b.attr("rel")) c(b);else {
                  f = a(b.prop("tagName") + '[rel="' + b.attr("rel") + '"]');
                  for (var j = 0; j < f.length; j = ++j) c(a(f[j])), f[j] === b[0] && (g = j);
                }
                var k = e.scrollTop() + this.options.positionFromTop - 50,
                  l = e.scrollLeft();
                this.$lightbox.css({
                  top: k + "px",
                  left: l + "px"
                }).fadeIn(this.options.fadeDuration), this.changeImage(g);
              }, b.prototype.changeImage = function (b) {
                var c = this;
                this.disableKeyboardNav();
                var d = this.$lightbox.find(".sby_lb-image");
                this.$overlay.fadeIn(this.options.fadeDuration), a(".sby_lb-loader").fadeIn("slow"), this.$lightbox.find(".sby_lb-image, .sby_lb-nav, .sby_lb-prev, .sby_lb-next, .sby_lb-dataContainer, .sby_lb-numbers, .sby_lb-caption").hide(), this.$outerContainer.addClass("animating");
                var e = new Image();
                e.onload = function () {
                  var f, g, h, i, j, k, l;
                  var sbyArrowWidth = 100;
                  d.attr("src", c.album[b].link), f = a(e), d.width(e.width), d.height(e.height), c.options.fitImagesInViewport && (l = a(window).width(), k = a(window).height(), j = l - c.containerLeftPadding - c.containerRightPadding - 20 - sbyArrowWidth, i = k - c.containerTopPadding - c.containerBottomPadding - 150, (e.width > j || e.height > i) && (e.width / j > e.height / i ? (h = j, g = parseInt(e.height / (e.width / h), 10), d.width(h), d.height(g)) : (g = i, h = parseInt(e.width / (e.height / g), 10), d.width(h), d.height(g)))), c.sizeContainer(d.width(), d.height());
                }, e.src = this.album[b].link, this.currentImageIndex = b;
              }, b.prototype.sizeOverlay = function () {
                this.$overlay.width(a(window).width()).height(a(document).height());
              }, b.prototype.sizeContainer = function (a, b) {
                function c() {
                  d.$lightbox.find(".sby_lb-dataContainer").width(g), d.$lightbox.find(".sby_lb-prevLink").height(h), d.$lightbox.find(".sby_lb-nextLink").height(h), d.showImage();
                }
                var d = this,
                  e = this.$outerContainer.outerWidth(),
                  f = this.$outerContainer.outerHeight(),
                  g = a + this.containerLeftPadding + this.containerRightPadding,
                  h = b + this.containerTopPadding + this.containerBottomPadding;
                e !== g || f !== h ? this.$outerContainer.animate({
                  width: g,
                  height: h
                }, this.options.resizeDuration, "swing", function () {
                  c();
                }) : c();
              }, b.prototype.showImage = function () {
                this.$lightbox.find(".sby_lb-loader").hide(), this.$lightbox.find(".sby_lb-image").fadeIn("slow"), this.updateNav(), this.updateDetails(), this.preloadNeighboringImages(), this.enableKeyboardNav();
              }, b.prototype.updateNav = function () {
                var a = !1;
                try {
                  document.createEvent("TouchEvent"), a = this.options.alwaysShowNavOnTouchDevices ? !0 : !1;
                } catch (b) {}
                this.$lightbox.find(".sby_lb-nav").show(), this.album.length > 1 && (this.options.wrapAround ? (a && this.$lightbox.find(".sby_lb-prev, .sby_lb-next").css("opacity", "1"), this.$lightbox.find(".sby_lb-prev, .sby_lb-next").show()) : (this.currentImageIndex > 0 && (this.$lightbox.find(".sby_lb-prev").show(), a && this.$lightbox.find(".sby_lb-prev").css("opacity", "1")), this.currentImageIndex < this.album.length - 1 && (this.$lightbox.find(".sby_lb-next").show(), a && this.$lightbox.find(".sby_lb-next").css("opacity", "1"))));
              }, b.prototype.updateDetails = function () {
                var b = this;

                /** NEW PHOTO ACTION **/
                if (jQuery('iframe.sby_lb-player-loaded').length) {
                  jQuery('.sby_lb-player-placeholder').replaceWith(jQuery('iframe.sby_lb-player-loaded'));
                  jQuery('iframe.sby_lb-player-loaded').removeClass('sby_lb-player-loaded').show();
                }
                //Switch video when either a new popup or navigating to new one
                var feed = window.sby.feeds[this.album[this.currentImageIndex].feedIndex];
                lbBuilder.beforePlayerSetup(this.$lightbox, this.album[this.currentImageIndex], this.currentImageIndex, this.album, feed);
                if (sby_supports_video()) {
                  jQuery('#sby_lightbox').removeClass('sby_video_lightbox');
                  if (feed.settings.consentGiven && this.album[this.currentImageIndex].video.length) {
                    jQuery('.sby_gdpr_notice').remove();
                    var playerID = 'sby_lb-player';
                    jQuery('#sby_lightbox').addClass('sby_video_lightbox');
                    if (!window.sbyOptions.isPro) {
                      jQuery('#sby_lightbox').addClass('sby_lightbox_free');
                    }
                    var videoID = this.album[this.currentImageIndex].video,
                      autoplay = sbyOptions.autoplay;
                    if (typeof window.sbyLightboxPlayer === 'undefined') {
                      var args = {
                        host: window.location.protocol + feed.embedURL,
                        videoId: videoID,
                        playerVars: {
                          modestbranding: 1,
                          rel: 0,
                          autoplay: autoplay
                        },
                        events: {
                          'onStateChange': function onStateChange(data) {
                            var videoID = data.target.getVideoData()['video_id'];
                            feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
                          }
                        }
                      };
                      feed.maybeAddCTA(playerID);
                      window.sbyLightboxPlayer = new window.YT.Player(playerID, args);
                    } else {
                      window.sbyLightboxPlayer.loadVideoById(videoID);
                    }
                    this.$outerContainer.removeClass("animating");
                    this.$lightbox.find(".sby_lb-dataContainer").fadeIn(this.options.resizeDuration, function () {
                      return b.sizeOverlay();
                    });
                    setTimeout(function () {
                      $('#sby_lightbox .sby_lb-player').css({
                        'height': $('#sby_lightbox .sby_lb-outerContainer').height() + 'px',
                        'width': $('#sby_lightbox .sby_lb-outerContainer').width() + 'px',
                        'top': 0
                      });
                    }, 1);
                    if (this.$lightbox.find('iframe').length) {
                      this.$lightbox.find('iframe').attr('title', this.album[this.currentImageIndex].videoTitle);
                    }
                  } else {
                    var fullImage = $('.sby_item[data-video-id=' + this.album[this.currentImageIndex].video + ']').find('.sby_video_thumbnail').attr('data-full-res');
                    $('.sby_lb-image').attr('src', fullImage);
                    this.$outerContainer.removeClass("animating");
                    this.$lightbox.find(".sby_lb-dataContainer").fadeIn(this.options.resizeDuration, function () {
                      return b.sizeOverlay();
                    });
                    jQuery(".sby_lb-container").prepend('<a href="https://www.youtube.com/watch?v=' + this.album[this.currentImageIndex].video + '" target="_blank" rel="noopener noreferrer" class="sby_gdpr_notice"><svg style="color: rgba(255,255,255,1)" class="svg-inline--fa fa-play fa-w-14 sby_playbtn" aria-label="Play" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="play" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg></a>');
                  }
                  lbBuilder.afterPlayerSetup(this.$lightbox, this.album[this.currentImageIndex], this.currentImageIndex, this.album);
                  if (this.album.length > 1 && this.options.showImageNumberLabel) {
                    this.$lightbox.find(".sby_lb-number").text(this.options.albumLabel(this.currentImageIndex + 1, this.album.length)).fadeIn("fast");
                  } else {
                    this.$lightbox.find(".sby_lb-number").hide();
                  }
                }
              }, b.prototype.preloadNeighboringImages = function () {
                if (this.album.length > this.currentImageIndex + 1) {
                  var a = new Image();
                  a.src = this.album[this.currentImageIndex + 1].link;
                }
                if (this.currentImageIndex > 0) {
                  var b = new Image();
                  b.src = this.album[this.currentImageIndex - 1].link;
                }
              }, b.prototype.enableKeyboardNav = function () {
                a(document).on("keyup.keyboard", a.proxy(this.keyboardAction, this));
              }, b.prototype.disableKeyboardNav = function () {
                a(document).off(".keyboard");
              }, b.prototype.keyboardAction = function (a) {
                var KEYCODE_ESC = 27;
                var KEYCODE_LEFTARROW = 37;
                var KEYCODE_RIGHTARROW = 39;
                var keycode = event.keyCode;
                var key = String.fromCharCode(keycode).toLowerCase();
                if (keycode === KEYCODE_ESC || key.match(/x|o|c/)) {
                  if (sby_supports_video()) $('#sby_lightbox video.sby_video')[0].pause();
                  $('#sby_lightbox iframe').attr('src', '');
                  this.end();
                } else if (key === 'p' || keycode === KEYCODE_LEFTARROW) {
                  if (this.currentImageIndex !== 0) {
                    this.changeImage(this.currentImageIndex - 1);
                  } else if (this.options.wrapAround && this.album.length > 1) {
                    this.changeImage(this.album.length - 1);
                  }
                  if (sby_supports_video()) $('#sby_lightbox video.sby_video')[0].pause();
                  $('#sby_lightbox iframe').attr('src', '');
                } else if (key === 'n' || keycode === KEYCODE_RIGHTARROW) {
                  if (this.currentImageIndex !== this.album.length - 1) {
                    this.changeImage(this.currentImageIndex + 1);
                  } else if (this.options.wrapAround && this.album.length > 1) {
                    this.changeImage(0);
                  }
                  lbBuilder.pausePlayer();
                }
              }, b.prototype.end = function () {
                this.disableKeyboardNav(), a(window).off("resize", this.sizeOverlay), this.$lightbox.fadeOut(this.options.fadeDuration), this.$overlay.fadeOut(this.options.fadeDuration), a("select, object, embed").css({
                  visibility: "visible"
                });
              }, b;
            }();
          a(function () {
            {
              var a = new b();
              new c(a);
              //Lightbox hide photo function
              $('.sby_lightbox_action a').off().on('click', function () {
                $(this).parent().find('.sby_lightbox_tooltip').toggle();
              });
            }
          });
        }).call(this);
        window.sbyOptions.lightboxCreated = true;
      },
      createFeeds: function createFeeds(args) {
        if (!sbyOptions.isAdmin && sbyOptions.lightboxCreated === undefined) {
          window.sby.createLightbox();
        }
        args.whenFeedsCreated($('.sb_youtube').each(function (index) {
          $(this).attr('data-sby-index', index + 1);
          $(this).find('.sby_player').replaceWith('<div id="sby_player' + index + '"></div>');
          var $self = $(this),
            flags = typeof $self.attr('data-sby-flags') !== 'undefined' ? $self.attr('data-sby-flags').split(',') : [],
            general = typeof $self.attr('data-options') !== 'undefined' ? JSON.parse($self.attr('data-options')) : {};
          if (flags.indexOf('testAjax') > -1) {
            window.sby.triggeredTest = true;
            var submitData = {
                'action': 'sby_on_ajax_test_trigger'
              },
              onSuccess = function onSuccess(data) {
                console.log('did test');
              };
            sbyAjax(submitData, onSuccess);
          }
          var feedOptions = {
            cols: $self.attr('data-cols'),
            colsmobile: $self.attr('data-colsmobile') !== 'same' ? $self.attr('data-colsmobile') : $self.attr('data-cols'),
            num: $self.attr('data-num'),
            imgRes: $self.attr('data-res'),
            feedID: $self.attr('data-feedid'),
            postID: typeof $self.attr('data-postid') !== 'undefined' ? $self.attr('data-postid') : 'unknown',
            shortCodeAtts: $self.attr('data-shortcode-atts'),
            resizingEnabled: flags.indexOf('resizeDisable') === -1,
            imageLoadEnabled: flags.indexOf('imageLoadDisable') === -1,
            debugEnabled: flags.indexOf('debug') > -1,
            favorLocal: flags.indexOf('favorLocal') > -1,
            ajaxPostLoad: flags.indexOf('ajaxPostLoad') > -1,
            checkWPPosts: flags.indexOf('checkWPPosts') > -1,
            singleCheckPosts: flags.indexOf('singleCheckPosts') > -1,
            narrowPlayer: flags.indexOf('narrowPlayer') > -1,
            gdpr: flags.indexOf('gdpr') > -1,
            consentGiven: flags.indexOf('gdpr') === -1,
            noCDN: flags.indexOf('disablecdn') > -1,
            allowCookies: flags.indexOf('allowcookies') > -1,
            lightboxEnabled: typeof $self.attr('data-sby-supports-lightbox') !== 'undefined',
            locator: flags.indexOf('locator') > -1,
            autoMinRes: 1,
            general: general,
            subscribeBarEnabled: true
          };
          window.sby.feeds[index] = sbyGetNewFeed(this, index, feedOptions);
          if (typeof window.sbyAPIReady !== 'undefined') {
            window.sby.feeds[index].playerAPIReady = true;
          }
          window.sby.feeds[index].setResizedImages();
          window.sby.feeds[index].init();
          var evt = jQuery.Event('sbyafterfeedcreate');
          evt.feed = window.sby.feeds[index];
          jQuery(window).trigger(evt);
        }));
      },
      afterFeedsCreated: function afterFeedsCreated() {
        // enable header hover action
        $('.sb_youtube_header').each(function () {
          var $thisHeader = $(this);
          $thisHeader.find('.sby_header_link').on('mouseenter mouseleave', function (e) {
            switch (e.type) {
              case 'mouseenter':
                $thisHeader.find('.sby_header_img_hover').addClass('sby_fade_in');
                break;
              case 'mouseleave':
                $thisHeader.find('.sby_header_img_hover').removeClass('sby_fade_in');
                break;
            }
          });
        });
        if (window.sbyAPIReady) {
          var evt = jQuery.Event('sbyfeedandytready');
          jQuery(window).trigger(evt);
        }
      },
      encodeHTML: function encodeHTML(raw) {
        // make sure passed variable is defined
        if (typeof raw === 'undefined') {
          return '';
        }
        // replace greater than and less than symbols with html entity to disallow html in comments
        var encoded = raw.replace(/(>)/g, '&gt;'),
          encoded = encoded.replace(/(<)/g, '&lt;');
        encoded = encoded.replace(/(&lt;br\/&gt;)/g, '<br>');
        encoded = encoded.replace(/(&lt;br&gt;)/g, '<br>');
        return encoded;
      },
      urlDetect: function urlDetect(text) {
        var urlRegex = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
        return text.match(urlRegex);
      },
      ctaDetect: function ctaDetect(text) {
        var ctaMatches = text.match(/{Link:(.*)}/g),
          cta = false;
        if (ctaMatches !== null) {
          var urlMatches = window.sby.urlDetect(ctaMatches[0]);
          if (urlMatches !== null) {
            var url = urlMatches[0].trim(),
              sbyButtonText = ctaMatches[0].replace('{Link:', '').replace('}', '').replace(url, '').replace('  ', ' ').trim();
            cta = {
              callback: 'link',
              url: url,
              text: sbyButtonText
            };
          } else {
            console.log('CTA found but no URL');
          }
        }
        return cta;
      },
      shuffle: function shuffle(array) {
        var currentIndex = array.length,
          temporaryValue,
          randomIndex;

        // While there remain elements to shuffle...
        while (0 !== currentIndex) {
          // Pick a remaining element...
          randomIndex = Math.floor(Math.random() * currentIndex);
          currentIndex -= 1;

          // And swap it with the current element.
          temporaryValue = array[currentIndex];
          array[currentIndex] = array[randomIndex];
          array[randomIndex] = temporaryValue;
        }
        return array;
      }
    };
    function SbyFeed(el, index, settings) {
      this.el = el;
      this.index = index;
      this.settings = settings;
      this.placeholderURL = window.sby.options.placeholder;
      if (settings.narrowPlayer) {
        this.placeholderURL = window.sby.options.placeholderNarrow;
      }
      this.playerAPIReady = false;
      this.consentGiven = settings.consentGiven;
      this.players = {};
      this.minImageWidth = 0;
      this.imageResolution = 150;
      this.resizedImages = {};
      this.needsResizing = [];
      this.outOfPages = false;
      this.isInitialized = false;
      this.mostRecentlyLoadedPosts = [];
      this.embedURL = '//www.youtube-nocookie.com';
      if (settings.allowCookies) {
        this.embedURL = '//www.youtube.com';
      }
    }
    SbyFeed.prototype = {
      init: function init() {
        var feed = this;
        feed.settings.consentGiven = feed.checkConsent();
        if (feed.settings.consentGiven) {
          window.sby.maybeAddYTAPI();
        }
        if (feed.settings.noCDN && !feed.settings.consentGiven) {
          if ($(this.el).find('.sb_youtube_header').length) {
            $(this.el).find('.sb_youtube_header').addClass('sby_no_consent');
          } else if ($(this.el).prev('.sb_youtube_header').length) {
            $(this.el).prev('.sb_youtube_header').addClass('sby_no_consent');
          }
        }
        if ($(this.el).find('#sby_mod_error').length) {
          $(this.el).prepend($(this.el).find('#sby_mod_error'));
        }
        if (this.settings.ajaxPostLoad) {
          this.getNewPostSet();
        } else {
          this.afterInitialImagesLoaded();
          //Only check the width once the resize event is over
        }
        var sby_delay = function () {
          var sby_timer = 0;
          return function (sby_callback, sby_ms) {
            clearTimeout(sby_timer);
            sby_timer = setTimeout(sby_callback, sby_ms);
          };
        }();
        jQuery(window).on('resize', function () {
          sby_delay(function () {
            feed.afterResize();
          }, 1);
        });
      },
      initLayout: function initLayout() {
        this.initGalleryLayout();
      },
      initGalleryLayout: function initGalleryLayout() {
        var $self = $(this.el),
          feed = this;
        if ($self.hasClass('sby_layout_gallery') && $self.find('.sby_player_outer_wrap').length) {
          this.maybeRaiseSingleImageResolution($self.find('.sby_player_outer_wrap'), 0, true);
          $self.find('.sby_player_outer_wrap .sby_video_thumbnail').off().on('click', function (event) {
            if ((!feed.settings.lightboxEnabled || feed.settings.lightboxEnabled && feed.settings.noCDN) && (feed.settings.noCDN || !feed.settings.consentGiven)) {
              if ($(this).closest('.sby_item').length && typeof $(this).closest('.sby_item').attr('data-video-id') !== 'undefined') {
                $(this).attr('href', 'https://www.youtube.com/watch?v=' + $(this).closest('.sby_item').attr('data-video-id'));
              }
              return;
            }
            event.preventDefault();
            feed.onThumbnailClick($(this), true);
          });
          $self.find('.sby_item').first().addClass('sby_current');
          $self.on('mouseenter', function () {
            if (!feed.canCreatePlayer()) {
              return;
            }
            if (!$self.find('.sby_player_outer_wrap iframe').length) {
              $self.addClass('sby_player_added').find('.sby_player_outer_wrap').addClass('sby_player_loading');
              $self.find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').show().removeClass('sby_hidden');
              feed.createPlayer('sby_player' + feed.index);
            } else if (typeof feed.player === 'undefined' && feed.playerEagerLoaded()) {
              feed.createPlayer('sby_player' + feed.index);
            }
          });
          if (window.sbySemiEagerLoading) {
            feed.createPlayer('sby_player' + feed.index);
          }
          if (feed.settings.noCDN) {
            $self.find('.sby_player_outer_wrap').append('<div class="sby_play_btn">\n' + '                        <span class="sby_play_btn_bg"></span>\n' + '                    <svg aria-hidden="true" focusable="false" data-prefix="fab" data-icon="youtube" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="svg-inline--fa fa-youtube fa-w-18"><path fill="currentColor" d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z" class=""></path></svg>                    </div>');
          }
        }
      },
      createPlayer: function createPlayer(playerID, videoID, autoplay, args) {
        var $self = $(this.el),
          feed = this;
        videoID = typeof videoID !== 'undefined' ? videoID : this.getVideoID($self.find('.sby_item').first());
        autoplay = typeof autoplay !== 'undefined' ? autoplay : 0;

        // do not create player in customizer preview
        if (sbyOptions.isCustomizer !== undefined && sbyOptions.isCustomizer) {
          return;
        }
        if (typeof args === 'undefined') {
          args = {
            host: window.location.protocol + feed.embedURL,
            videoId: videoID,
            playerVars: {
              modestbranding: 1,
              rel: 0,
              autoplay: autoplay
            }
          };
        }
        if (typeof args.events === 'undefined') {
          args.events = {
            'onReady': function onReady() {
              $self.find('.sby_player_outer_wrap').removeClass('sby_player_loading').find('.sby_video_thumbnail').css('z-index', -1).find('.sby_loader').hide().addClass('sby_hidden');
              if ($('#' + playerID).length && $('#' + playerID).closest('.sby_video_thumbnail_wrap').find('.sby_video_thumbnail').length) {
                $('#' + playerID).closest('.sby_video_thumbnail_wrap').find('.sby_video_thumbnail').fadeTo(0, 'slow', function () {
                  $(this).css('z-index', -1);
                  $(this).find('.sby_loader').hide().addClass('sby_hidden');
                  $(this).closest('.sby_item').removeClass('sby_player_loading');
                });
              }
              var evt = jQuery.Event('sbyafterplayerready');
              evt.feed = feed;
              evt.player = this;
              jQuery(window).trigger(evt);
            },
            'onStateChange': function onStateChange(data) {
              $self.find('.sby_player_outer_wrap').removeClass('sby_player_loading').find('.sby_video_thumbnail').css('z-index', -1).find('.sby_loader').hide().addClass('sby_hidden');
              feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
              if (data.data !== 1) return;
              var feedID;
              if (feed.el) {
                var shortcodeAttr = feed.el.getAttribute('data-shortcode-atts');
                if (shortcodeAttr) {
                  var _JSON$parse;
                  feedID = (_JSON$parse = JSON.parse(shortcodeAttr)) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.feed;
                }
              }
              document.dispatchEvent(new CustomEvent('sby-video-interaction', {
                detail: {
                  videoID: videoID,
                  feedID: feedID
                }
              }));
              if (typeof feed.players !== 'undefined') {
                $self.find('.sby_item').each(function () {
                  var itemVidID = feed.getVideoID($(this));
                  if ($(this).find('iframe').length && itemVidID !== videoID) {
                    if (typeof feed.players[itemVidID] !== 'undefined' && typeof feed.players[itemVidID].pauseVideo === 'function') {
                      feed.players[itemVidID].pauseVideo();
                    }
                  }
                });
              }
            }
          };
        }
        if (window.sbyEagerLoading) {
          var newPlayer = YT.get(playerID);
        } else {
          var newPlayer = new window.YT.Player(playerID, args);
        }
        this.maybeAddCTA(playerID);
        if ($self.hasClass('sby_layout_list') && typeof this.players[videoID] === 'undefined') {
          this.players[videoID] = newPlayer;
        } else if (typeof this.player === 'undefined') {
          this.player = newPlayer;
        }
        var evt = jQuery.Event('sbyafterplayercreated');
        evt.feed = this;
        jQuery(window).trigger(evt);
        $self.find('.sby_player_outer_wrap .sby_play_btn').remove();
        return newPlayer;
      },
      afterStateChange: function afterStateChange(playerID, videoID, data, $player) {},
      afterInitialImagesLoaded: function afterInitialImagesLoaded() {
        this.initLayout();
        this.loadMoreButtonInit();
        this.hideExtraItemsForWidth();
        this.beforeNewImagesRevealed();
        this.revealNewImages();
        this.afterNewImagesRevealed();
        this.afterFeedSet();
        this.sizePlayer();
        this.sizeItems();
        if (this.settings.consentGiven) {
          this.applyFullFeatures();
        } else {
          this.removeFeatures();
        }
      },
      afterResize: function afterResize() {
        this.setImageHeight();
        this.setImageResolution();
        this.maybeRaiseImageResolution();
        this.setImageSizeClass();
      },
      afterLoadMoreClicked: function afterLoadMoreClicked($button) {
        $button.find('.sby_loader').removeClass('sby_hidden');
        $button.find('.sby_btn_text').addClass('sby_hidden');
        $button.closest('.sb_youtube').find('.sby_num_diff_hide').addClass('sby_transition').removeClass('sby_num_diff_hide');
      },
      afterNewImagesLoaded: function afterNewImagesLoaded() {
        var $self = $(this.el),
          feed = this;
        this.beforeNewImagesRevealed();
        this.revealNewImages();
        this.afterNewImagesRevealed();
        this.sizePlayer();
        this.sizeItems();
        setTimeout(function () {
          //Hide the loader in the load more button
          $self.find('.sby_loader').addClass('sby_hidden');
          $self.find('.sby_btn_text').removeClass('sby_hidden');
          feed.maybeRaiseImageResolution();
        }, 1);
        if (this.settings.consentGiven) {
          this.applyFullFeatures();
        } else {
          this.removeFeatures();
        }
      },
      beforeNewImagesRevealed: function beforeNewImagesRevealed() {
        this.setImageHeight();
        this.maybeRaiseImageResolution(true);
        this.setImageSizeClass();
      },
      afterFeedSet: function afterFeedSet() {},
      sizePlayer: function sizePlayer() {
        var $self = $(this.el),
          feed = this;
        if ($self.hasClass('sby_layout_gallery')) {
          $playerThumbnail = $self.find('.sby_player_item').find('.sby_player_video_thumbnail');
          var playerWidth = $playerThumbnail.innerWidth(),
            newPlayerHeight = Math.floor(playerWidth * 9 / 16);
          if (feed.settings.narrowPlayer) {
            newPlayerHeight = Math.floor(playerWidth * 3 / 4);
          }
          $playerThumbnail.css('height', newPlayerHeight + 'px').css('overflow', 'hidden');
        } else if ($self.hasClass('sby_layout_list')) {
          $self.find('.sby_item').each(function () {
            $playerThumbnail = $(this).find('.sby_item_video_thumbnail');
            var playerWidth = $playerThumbnail.innerWidth(),
              newPlayerHeight = Math.floor(playerWidth * 9 / 16);
            if (feed.settings.narrowPlayer) {
              newPlayerHeight = Math.floor(playerWidth * 3 / 4);
            }
            $playerThumbnail.css('height', newPlayerHeight + 'px').css('overflow', 'hidden');
          });
        }
      },
      sizeItems: function sizeItems() {
        var $self = $(this.el),
          feed = this;
        if (!$self.hasClass('sby_layout_list')) {
          $self.find('.sby_item').find('.sby_item_video_thumbnail').each(function () {
            if ($(this).hasClass('sby_imgLiquid_ready')) {
              var thumbWidth = $(this).innerWidth(),
                newThumbHeight = Math.floor(thumbWidth * 9 / 16);
              $(this).css('height', newThumbHeight + 'px').css('overflow', 'hidden');
            }
          });
        }
      },
      revealNewImages: function revealNewImages() {
        var $self = $(this.el),
          feed = this;
        this.applyImageLiquid();

        // Call Custom JS if it exists
        if (typeof sbyCustomJS == 'function') setTimeout(function () {
          sbyCustomJS();
        }, 100);
        $self.find('.sby-screenreader').find('img').remove();
        $self.find('.sby_item.sby_new').each(function (index) {
          var $self = jQuery(this);

          //Photo links
          //If lightbox is disabled
          videoID = $self.attr('data-video-id');
          if (window.sbyEagerLoading && feed.canCreatePlayer() && $('#sby_player_' + videoID).length) {
            player = new YT.Player('sby_player_' + videoID, {
              height: '100',
              width: '100',
              videoId: videoID,
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: 0
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  if (data.data !== 1) return;
                  document.dispatchEvent(videoInteractionEvent, {
                    videoID: videoID
                  });
                  $self.find('.sby_item').each(function () {
                    var itemVidID = jQuery(this).attr('data-video-id');
                    if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                      YT.get('sby_player_' + itemVidID).pauseVideo();
                    }
                  });
                }
              }
            });
          }
          $self.find('.sby_video_thumbnail').on('mouseenter', function () {
            feed.onThumbnailEnter($(this), false);
          });
          $self.find('.sby_player_wrap').on('mouseleave', function () {
            feed.onThumbnailLeave($(this), false);
          });
          //init click
          $self.find('.sby_video_thumbnail').on('click', function (event) {
            if ((!feed.settings.lightboxEnabled || feed.settings.lightboxEnabled && feed.settings.noCDN) && (feed.settings.noCDN || !feed.settings.consentGiven)) {
              if ($(this).closest('.sby_item').length && typeof $(this).closest('.sby_item').attr('data-video-id') !== 'undefined') {
                $(this).attr('href', 'https://www.youtube.com/watch?v=' + $(this).closest('.sby_item').attr('data-video-id'));
              }
              return;
            }
            event.preventDefault();
            feed.onThumbnailClick($(this), false);
          });

          // lightbox
          if (feed.settings.lightboxEnabled) {
            $self.find('.sby_video_thumbnail').attr('data-sby-lightbox', feed.index);
            if (typeof sbyOptions !== 'undefined' && typeof sbyOptions.lightboxPlaceholder !== 'undefined') {
              if (feed.settings.narrowPlayer) {
                $self.find('.sby_video_thumbnail').attr('href', sbyOptions.lightboxPlaceholderNarrow);
              } else {
                $self.find('.sby_video_thumbnail').attr('href', sbyOptions.lightboxPlaceholder);
              }
            }
          }
          feed.afterItemRevealed($self);

          // no info
          if ($self.find('.sby_info_item').text().trim() === '') {
            $self.find('.sby_info_item').addClass('sby_no_space');
          }
        }); //End .sby_item each

        $self.find('.sby_player_item').each(function (index) {
          var $self = jQuery(this);
          feed.afterItemRevealed($self);
        }); //End .sby_item each

        //Remove the new class after 500ms, once the sorting is done
        setTimeout(function () {
          $self.find('.sby_item.sby_new').removeClass('sby_new');
          //Loop through items and remove class to reveal them
          var time = 1,
            num = $self.find('.sby_transition').length;
          $self.find('.sby_transition').each(function (index) {
            var $sby_item_transition_el = jQuery(this);
            setTimeout(function () {
              $sby_item_transition_el.removeClass('sby_transition');
            }, time);
            //time += 10;
          });
        }, 1);
      },
      afterItemRevealed: function afterItemRevealed() {},
      afterNewImagesRevealed: function afterNewImagesRevealed() {
        this.listenForVisibilityChange();
        this.sendNeedsResizingToServer();
        this.sendCheckWPPostsToServer();
        if (!this.settings.imageLoadEnabled) {
          $('.sby_no_resraise').removeClass('sby_no_resraise');
        }
        var evt = $.Event('sbyafterimagesloaded');
        evt.el = $(this.el);
        $(window).trigger(evt);
      },
      setResizedImages: function setResizedImages() {
        if ($(this.el).find('.sby_resized_image_data').length && typeof $(this.el).find('.sby_resized_image_data').attr('data-resized') !== 'undefined' && $(this.el).find('.sby_resized_image_data').attr('data-resized').indexOf('{"') === 0) {
          this.resizedImages = JSON.parse($(this.el).find('.sby_resized_image_data').attr('data-resized'));
          $(this.el).find('.sby_resized_image_data').remove();
        }
      },
      sendNeedsResizingToServer: function sendNeedsResizingToServer() {
        var feed = this;
        if (feed.needsResizing.length > 0 && feed.settings.resizingEnabled) {
          var itemOffset = $(this.el).find('.sby_item').length;
          var submitData = {
            action: 'sby_resized_images_submit',
            needs_resizing: feed.needsResizing,
            offset: itemOffset,
            feed_id: feed.settings.feedID,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            atts: feed.settings.shortCodeAtts
          };
          var onSuccess = function onSuccess(data) {
            if (data.trim().indexOf('{') === 0) {
              var response = JSON.parse(data);
              if (feed.settings.debugEnabled) {
                console.log(response);
              }
            }
          };
          sbyAjax(submitData, onSuccess);
        }
      },
      sendCheckWPPostsToServer: function sendCheckWPPostsToServer() {
        var feed = this;
        if (feed.settings.checkWPPosts || feed.settings.singleCheckPosts) {
          var feedID = typeof feed.settings.feedID !== 'undefined' ? feed.settings.feedID : 'sby_single',
            posts = feed.mostRecentlyLoadedPosts;
          feed.mostRecentlyLoadedPosts = [];
          var submitData = {
            action: 'sby_check_wp_submit',
            feed_id: feedID,
            atts: feed.settings.shortCodeAtts,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            offset: !$(this.el).hasClass('sby_layout_carousel') ? $(this.el).find('.sby_item').length : Math.floor($(this.el).find('.sby_item').length / 2 - 1),
            posts: posts
          };
          var onSuccess = function onSuccess(data) {
            if (data.trim().indexOf('{') === 0) {
              var response = JSON.parse(data);
              if (feed.settings.debugEnabled) {
                console.log(response);
              }
              feed.afterSendCheckWPPostsToServer(response);
            }
          };
          sbyAjax(submitData, onSuccess);
        }
      },
      afterSendCheckWPPostsToServer: function afterSendCheckWPPostsToServer(response) {},
      loadMoreButtonInit: function loadMoreButtonInit() {
        var $self = $(this.el),
          feed = this;
        $self.find('.sby_footer .sby_load_btn').off().on('click', function () {
          feed.afterLoadMoreClicked(jQuery(this));
          feed.getNewPostSet();
        }); //End click event
      },
      getNewPostSet: function getNewPostSet() {
        var $self = $(this.el),
          feed = this;
        var itemOffset = $self.find('.sby_item').length,
          submitData = {
            action: 'sby_load_more_clicked',
            offset: itemOffset,
            feed_id: feed.settings.feedID,
            atts: feed.settings.shortCodeAtts,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            current_resolution: feed.imageResolution
          };
        var onSuccess = function onSuccess(data) {
          if (data.trim().indexOf('{') === 0) {
            var response = JSON.parse(data),
              checkWPPosts = typeof response.feedStatus.checkWPPosts !== 'undefined' ? response.feedStatus.checkWPPosts : false;
            ;
            if (feed.settings.debugEnabled) {
              console.log(response);
            }
            if (checkWPPosts) {
              feed.settings.checkWPPosts = true;
            } else {
              feed.settings.checkWPPosts = false;
            }
            feed.appendNewPosts(response.html);
            feed.addResizedImages(response.resizedImages);
            if (feed.settings.ajaxPostLoad) {
              feed.settings.ajaxPostLoad = false;
              feed.afterInitialImagesLoaded();
            } else {
              feed.afterNewImagesLoaded();
            }
            if (!response.feedStatus.shouldPaginate) {
              feed.outOfPages = true;
              $self.find('.sby_load_btn').hide();
            } else {
              feed.outOfPages = false;
            }
            $('.sby_no_js').removeClass('sby_no_js');
            openComments();
          }
        };
        sbyAjax(submitData, onSuccess);
      },
      appendNewPosts: function appendNewPosts(newPostsHtml) {
        var $self = $(this.el),
          feed = this;
        if ($self.find('.sby_items_wrap .sby_item').length) {
          $self.find('.sby_items_wrap .sby_item').last().after(newPostsHtml);
        } else {
          $self.find('.sby_items_wrap').append(newPostsHtml);
        }
      },
      addResizedImages: function addResizedImages(resizedImagesToAdd) {
        for (var imageID in resizedImagesToAdd) {
          this.resizedImages[imageID] = resizedImagesToAdd[imageID];
        }
      },
      setImageHeight: function setImageHeight() {},
      maybeRaiseSingleImageResolution: function maybeRaiseSingleImageResolution($item, index, forceChange) {
        var feed = this,
          imgSrcSet = feed.getImageUrls($item),
          currentUrl = $item.find('.sby_video_thumbnail > img').attr('src'),
          currentRes = 150,
          aspectRatio = 1,
          // all thumbnails are oriented the same so the best calculation uses 1
          forceChange = typeof forceChange !== 'undefined' ? forceChange : false;
        if ($item.hasClass('sby_no_resraise') || !feed.settings.consentGiven && feed.settings.noCDN) {
          return;
        }
        $.each(imgSrcSet, function (index, value) {
          if (value === currentUrl) {
            currentRes = parseInt(index);
            // If the image has already been changed to an existing real source, don't force the change
            forceChange = false;
          }
        });
        //Image res
        var newRes = 640;
        switch (feed.settings.imgRes) {
          case 'thumb':
            newRes = 120;
            break;
          case 'medium':
            newRes = 320;
            break;
          case 'large':
            newRes = 480;
            break;
          case 'full':
            newRes = 640;
            break;
          default:
            var minImageWidth = Math.max(feed.settings.autoMinRes, $item.find('.sby_video_thumbnail').innerWidth()),
              thisImageReplace = feed.getBestResolutionForAuto(minImageWidth, aspectRatio, $(this.el).find('sby_item').first());
            switch (thisImageReplace) {
              case 480:
                newRes = 480;
                break;
              case 320:
                newRes = 320;
                break;
              case 120:
                newRes = 120;
                break;
            }
            break;
        }
        if (newRes > currentRes || currentUrl === feed.placeholderURL || forceChange) {
          if (feed.settings.debugEnabled) {
            var reason = currentUrl === feed.placeholderURL ? 'was placeholder' : 'too small';
            console.log('rais res for ' + currentUrl, reason);
          }
          var newUrl = imgSrcSet[newRes];
          $item.find('.sby_video_thumbnail > img').attr('src', newUrl);
          if ($item.find('.sby_video_thumbnail').hasClass('sby_imgLiquid_ready')) {
            $item.find('.sby_video_thumbnail').css('background-image', 'url("' + newUrl + '")');
          }
        }
        $item.find('img').on('error', function () {
          if (!$(this).hasClass('sby_img_error')) {
            $(this).addClass('sby_img_error');
            var sourceFromAPI = $(this).attr('src').indexOf('i.ytimg.com') > -1;
            if (!sourceFromAPI) {
              if (typeof $(this).closest('.sby_video_thumbnail').attr('data-full-res') !== 'undefined') {
                $(this).attr('src', $(this).closest('.sby_video_thumbnail').attr('data-full-res'));
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + $(this).closest('.sby_video_thumbnail').attr('data-full-res') + ')');
              } else if ($(this).closest('.sby_video_thumbnail').attr('href') !== 'undefined') {
                $(this).attr('src', $(this).closest('.sby_video_thumbnail').attr('href') + 'media?size=l');
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + $(this).closest('.sby_video_thumbnail').attr('href') + 'media?size=l)');
              }
            } else {
              feed.settings.favorLocal = true;
              var srcSet = feed.getImageUrls($(this).closest('.sby_item'));
              if (typeof srcSet[640] !== 'undefined') {
                $(this).attr('src', srcSet[640]);
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + srcSet[640] + ')');
              }
            }
            setTimeout(function () {
              feed.afterResize();
            }, 1);
          } else {
            console.log('unfixed error ' + $(this).attr('src'));
          }
        });
      },
      maybeRaiseImageResolution: function maybeRaiseImageResolution(justNew) {
        var feed = this,
          itemsSelector = typeof justNew !== 'undefined' && justNew === true ? '.sby_item.sby_new' : '.sby_item',
          forceChange = !feed.isInitialized ? true : false;
        $(feed.el).find(itemsSelector).each(function (index) {
          if (!$(this).hasClass('sby_num_diff_hide') && $(this).find('.sby_video_thumbnail').length && typeof $(this).find('.sby_video_thumbnail').attr('data-img-src-set') !== 'undefined') {
            feed.maybeRaiseSingleImageResolution($(this), index, forceChange);
          }
        }); //End .sby_item each
        feed.isInitialized = true;
      },
      getBestResolutionForAuto: function getBestResolutionForAuto(colWidth, aspectRatio, $item) {
        if (isNaN(aspectRatio) || aspectRatio < 1) {
          aspectRatio = 1;
        }
        var bestWidth = colWidth * aspectRatio,
          bestWidthRounded = Math.ceil(bestWidth / 10) * 10,
          customSizes = [120, 320, 480, 640];
        if ($item.hasClass('sby_highlighted')) {
          bestWidthRounded = bestWidthRounded * 2;
        }
        if (customSizes.indexOf(parseInt(bestWidthRounded)) === -1) {
          var done = false;
          $.each(customSizes, function (index, item) {
            if (item > parseInt(bestWidthRounded) && !done) {
              bestWidthRounded = item;
              done = true;
            }
          });
        }
        return bestWidthRounded;
      },
      hideExtraItemsForWidth: function hideExtraItemsForWidth() {
        if (this.layout === 'carousel') {
          return;
        }
        var $self = $(this.el),
          num = typeof $self.attr('data-num') !== 'undefined' && $self.attr('data-num') !== '' ? parseInt($self.attr('data-num')) : 1,
          nummobile = typeof $self.attr('data-nummobile') !== 'undefined' && $self.attr('data-nummobile') !== '' ? parseInt($self.attr('data-nummobile')) : num;
        if (!$self.hasClass('.sby_layout_carousel')) {
          if ($(window).width() < 480) {
            if (nummobile < $self.find('.sby_item').length) {
              $self.find('.sby_item').slice(nummobile - $self.find('.sby_item').length).addClass('sby_num_diff_hide');
            }
          } else {
            if (num < $self.find('.sby_item').length) {
              $self.find('.sby_item').slice(num - $self.find('.sby_item').length).addClass('sby_num_diff_hide');
            }
          }
        }
      },
      setImageSizeClass: function setImageSizeClass() {
        var $self = $(this.el);
        $self.removeClass('sby_small sby_medium');
        var feedWidth = $self.innerWidth(),
          photoPadding = parseInt($self.find('.sby_items_wrap').outerWidth() - $self.find('.sby_items_wrap').width()) / 2,
          cols = this.getColumnCount(),
          feedWidthSansPadding = feedWidth - photoPadding * (cols + 2),
          colWidth = feedWidthSansPadding / cols;
        if (colWidth > 140 && colWidth < 240) {
          $self.addClass('sby_medium');
        } else if (colWidth <= 140) {
          $self.addClass('sby_small');
        }
      },
      setMinImageWidth: function setMinImageWidth() {
        if ($(this.el).find('.sby_item .sby_video_thumbnail').first().length) {
          this.minImageWidth = $(this.el).find('.sby_item .sby_video_thumbnail').first().innerWidth();
        } else {
          this.minImageWidth = 150;
        }
      },
      setImageResolution: function setImageResolution() {
        if (this.settings.imgRes === 'auto') {
          this.imageResolution = 'auto';
        } else {
          switch (this.settings.imgRes) {
            case 'thumb':
              this.imageResolution = 150;
              break;
            case 'medium':
              this.imageResolution = 320;
              break;
            default:
              this.imageResolution = 640;
          }
        }
      },
      getImageUrls: function getImageUrls($item) {
        var srcSet = JSON.parse($item.find('.sby_video_thumbnail').attr('data-img-src-set').replace(/\\\//g, '/')),
          id = $item.attr('id').replace('sby_', '').replace('player_', '');
        if (typeof this.resizedImages[id] !== 'undefined' && this.resizedImages[id] !== 'video' && this.resizedImages[id] !== 'pending' && this.resizedImages[id].id !== 'error' && this.resizedImages[id].id !== 'video' && this.resizedImages[id].id !== 'pending') {
          if (typeof this.resizedImages[id]['sizes'] !== 'undefined') {
            var foundSizes = [];
            if (typeof this.resizedImages[id]['sizes']['full'] !== 'undefined') {
              foundSizes.push(640);
              srcSet[640] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
              $item.find('.sby_link_area').attr('href', sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg');
              $item.find('.sby_video_thumbnail').attr('data-full-res', sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg');
            }
            if (typeof this.resizedImages[id]['sizes']['low'] !== 'undefined') {
              foundSizes.push(320);
              srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
              if (this.settings.favorLocal && typeof this.resizedImages[id]['sizes']['full'] === 'undefined') {
                $item.find('.sby_link_area').attr('href', sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg');
                $item.find('.sby_video_thumbnail').attr('data-full-res', sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg');
              }
            }
            if (typeof this.resizedImages[id]['sizes']['thumb'] !== 'undefined') {
              foundSizes.push(150);
              srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'thumb.jpg';
            }
            if (this.settings.favorLocal) {
              if (foundSizes.indexOf(640) === -1) {
                if (foundSizes.indexOf(320) > -1) {
                  srcSet[640] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
                }
              }
              if (foundSizes.indexOf(320) === -1) {
                if (foundSizes.indexOf(640) > -1) {
                  srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
                } else if (foundSizes.indexOf(150) > -1) {
                  srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'thumb.jpg';
                }
              }
              if (foundSizes.indexOf(150) === -1) {
                if (foundSizes.indexOf(320) > -1) {
                  srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
                } else if (foundSizes.indexOf(640) > -1) {
                  srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
                }
              }
            }
          }
        } else if (typeof this.resizedImages[id] === 'undefined' || typeof this.resizedImages[id]['id'] !== 'undefined' && this.resizedImages[id]['id'] !== 'pending' && this.resizedImages[id]['id'] !== 'error') {
          this.addToNeedsResizing(id);
        }
        return srcSet;
      },
      getVideoID: function getVideoID($el) {
        if ($el.hasClass('sby_item') || $el.hasClass('sby_player_item')) {
          if (typeof $el.find('.sby_video_thumbnail').attr('data-video-id') !== 'undefined') {
            return $el.find('.sby_video_thumbnail').attr('data-video-id');
          }
        } else if ($el.closest('sby_item').length || $el.closest('sby_player_item').length) {
          var $targeEl = $el.closest('sby_item').length ? $el.closest('sby_item') : $el.closest('sby_player_item');
          if (typeof $targeEl.find('.sby_video_thumbnail').attr('data-video-id') !== 'undefined') {
            return $targeEl.find('.sby_video_thumbnail').attr('data-video-id');
          }
        } else if ($el.hasClass('sb_youtube')) {
          return $el.find('.sby_item').first().find('.sby_video_thumbnail').attr('data-video-id');
        } else if ($(this.el).find('.sby_video_thumbnail').first().length && typeof $(this.el).find('.sby_video_thumbnail').first().attr('data-video-id') !== 'undefined') {
          return $(this.el).find('.sby_video_thumbnail').first().attr('data-video-id');
        }
        return '';
      },
      getAvatarUrl: function getAvatarUrl(username, favorType) {
        if (username === '') {
          return '';
        }
        var availableAvatars = this.settings.general.avatars,
          favorType = typeof favorType !== 'undefined' ? favorType : 'local';
        if (favorType === 'local') {
          if (typeof availableAvatars['LCL' + username] !== 'undefined' && parseInt(availableAvatars['LCL' + username]) === 1) {
            return sbyOptions.resized_url + username + '.jpg';
          } else if (typeof availableAvatars[username] !== 'undefined') {
            return availableAvatars[username];
          } else {
            return '';
          }
        } else {
          if (typeof availableAvatars[username] !== 'undefined') {
            return availableAvatars[username];
          } else if (typeof availableAvatars['LCL' + username] !== 'undefined' && parseInt(availableAvatars['LCL' + username]) === 1) {
            return sbyOptions.resized_url + username + '.jpg';
          } else {
            return '';
          }
        }
      },
      addToNeedsResizing: function addToNeedsResizing(id) {
        if (this.needsResizing.indexOf(id) === -1) {
          this.needsResizing.push(id);
        }
      },
      applyImageLiquid: function applyImageLiquid() {
        var $self = $(this.el),
          feed = this;
        sbyAddImgLiquid();
        if (typeof $self.find(".sby_player_item").sby_imgLiquid == 'function') {
          if ($self.find('.sby_player_item').length) {
            $self.find(".sby_player_item .sby_player_video_thumbnail").sby_imgLiquid({
              fill: true
            });
          }
          $self.find(".sby_item .sby_item_video_thumbnail").sby_imgLiquid({
            fill: true
          });
        }
      },
      listenForVisibilityChange: function listenForVisibilityChange() {
        var feed = this;
        sbyAddVisibilityListener();
        if (typeof $(this.el).filter(':hidden').sbyVisibilityChanged == 'function') {
          //If the feed is initially hidden (in a tab for example) then check for when it becomes visible and set then set the height
          $(this.el).filter(':hidden').sbyVisibilityChanged({
            callback: function callback(element, visible) {
              feed.afterResize();
            },
            runOnLoad: false
          });
        }
      },
      getColumnCount: function getColumnCount() {
        var $self = $(this.el),
          cols = this.settings.cols,
          colsmobile = this.settings.colsmobile,
          returnCols = cols;
        sbyWindowWidth = window.innerWidth;
        if ($self.hasClass('sby_mob_col_auto')) {
          if (sbyWindowWidth < 640 && parseInt(cols) > 2 && parseInt(cols) < 7) returnCols = 2;
          if (sbyWindowWidth < 640 && parseInt(cols) > 6 && parseInt(cols) < 11) returnCols = 4;
          if (sbyWindowWidth <= 480 && parseInt(cols) > 2) returnCols = 1;
        } else if (sbyWindowWidth <= 480) {
          returnCols = colsmobile;
        }
        return parseInt(returnCols);
      },
      onThumbnailClick: function onThumbnailClick($clicked, isPlayer, videoID) {
        if (!this.canCreatePlayer()) {
          return;
        }
        var $self = $(this.el);
        if ($self.hasClass('sby_layout_gallery')) {
          $self.find('.sby_current').removeClass('sby_current');
          $clicked.closest('.sby_item').addClass('sby_current');
          $clicked.closest('.sby_item').addClass('sby_current');
          $self.addClass('sby_player_added').find('.sby_player_outer_wrap').addClass('sby_player_loading');
          $self.find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').show().removeClass('sby_hidden');
          if (!$self.find('.sby_player_outer_wrap iframe').length) {
            if (isPlayer) {
              this.createPlayer('sby_player' + this.index);
            } else {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($clicked.closest('.sby_item')) : videoID;
              this.createPlayer('sby_player' + this.index, videoID);
            }
          } else {
            if (isPlayer) {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($self.find('.sby_item').first()) : videoID;
              this.playVideoInPlayer(videoID);
            } else {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($clicked.closest('.sby_item')) : videoID;
              this.changePlayerInfo($clicked.closest('.sby_item'));
              this.playVideoInPlayer(videoID);
              this.afterVideoChanged();
            }
          }
          this.updateGalleryPlayerSubscribeBtn($clicked);
        } else if ($(this.el).hasClass('sby_layout_grid') || $(this.el).hasClass('sby_layout_carousel')) {
          var $sbyItem = $clicked.closest('.sby_item'),
            videoID = typeof videoID === 'undefined' ? this.getVideoID($sbyItem) : videoID;
          this.playVideoInPlayer(videoID);
          this.afterVideoChanged();
        } else if ($(this.el).hasClass('sby_layout_list')) {
          var $sbyItem = $clicked.closest('.sby_item'),
            videoID = typeof videoID === 'undefined' ? this.getVideoID($sbyItem) : videoID;
          if ($sbyItem.length && !$sbyItem.find('iframe').length) {
            $sbyItem.find('.sby_loader').show().removeClass('sby_hidden');
            $sbyItem.addClass('sby_player_loading sby_player_loaded');
            this.createPlayer('sby_player_' + videoID, videoID);
          } else {
            this.playVideoInPlayer(videoID, $sbyItem.attr('data-video-id'));
            this.afterVideoChanged();
          }
        }
      },
      onThumbnailEnter: function onThumbnailEnter($hovered) {
        if (!this.canCreatePlayer()) {
          return;
        }
        var $self = $(this.el);
        if ($self.hasClass('sby_layout_list')) {
          var $sbyItem = $hovered.closest('.sby_item'),
            videoID = this.getVideoID($sbyItem);
          if (!$sbyItem.find('iframe').length) {
            $sbyItem.find('.sby_loader').show().removeClass('sby_hidden');
            $sbyItem.addClass('sby_player_loading sby_player_loaded');
            this.createPlayer('sby_player_' + videoID, videoID, 0);
          }
        }
      },
      onThumbnailLeave: function onThumbnailLeave($hovered) {},
      changePlayerInfo: function changePlayerInfo($newItem) {},
      playerEagerLoaded: function playerEagerLoaded() {
        if (typeof this.player !== 'undefined' || $(this.el).hasClass('sby_player_loaded')) {
          return true;
        }
      },
      canCreatePlayer: function canCreatePlayer() {
        if ($(this.el).find('#sby_blank').length) {
          return false;
        }
        var concentGiven = this.settings.consentGiven;

        // Fix for elementor builder for list view. Where video would not load on hocer.
        var elementorCheck = window.sby.feeds[this.index].playerAPIReady && concentGiven;
        return this.playerEagerLoaded() || this.playerAPIReady && concentGiven || window.sbyAPIReady && concentGiven || elementorCheck;
      },
      playVideoInPlayer: function playVideoInPlayer(videoID, playerID) {
        if (typeof this.player !== 'undefined' && typeof this.player.loadVideoById !== 'undefined') {
          this.player.loadVideoById(videoID);
        } else if (typeof window.sbyLightboxPlayer !== 'undefined' && typeof window.sbyLightboxPlayer.loadVideoById !== 'undefined') {
          window.sbyLightboxPlayer.loadVideoById(videoID);
        } else if (typeof playerID !== 'undefined' && typeof this.players !== 'undefined' && typeof this.players[playerID] !== 'undefined' && typeof this.players[playerID].loadVideoById !== 'undefined') {
          this.players[playerID].loadVideoById(videoID);
        }
      },
      afterVideoChanged: function afterVideoChanged() {
        if ($(this.el).hasClass('sby_layout_gallery')) {
          $(this.el).find('.sby_player_outer_wrap').removeClass('sby_player_loading');
          $(this.el).find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').hide().addClass('sby_hidden');
          $('html, body').animate({
            scrollTop: $(this.el).find('.sby_player_outer_wrap').offset().top
          }, 300);
        }
      },
      updateGalleryPlayerSubscribeBtn: function updateGalleryPlayerSubscribeBtn($clicked) {
        var itemURL = $clicked.attr('href');
        var regex = /channel\/(.*)$/;
        var match = itemURL.match(regex);
        if (!match) {
          return;
        }
        var channelId = match[1];
        var subscribeBtnURL = 'http://www.youtube.com/channel/' + channelId + '?sub_confirmation=1&feature=subscribe-embed-click';
        $('.sby-channel-subscribe-btn a').attr('href', subscribeBtnURL);
      },
      checkConsent: function checkConsent() {
        if (this.settings.consentGiven || !this.settings.gdpr) {
          this.settings.noCDN = false;
          return true;
        }
        if (typeof CLI_Cookie !== "undefined") {
          // GDPR Cookie Consent by WebToffee
          if (CLI_Cookie.read(CLI_ACCEPT_COOKIE_NAME) !== null) {
            // WebToffee no longer uses this cookie but being left here to maintain backwards compatibility
            if (CLI_Cookie.read('cookielawinfo-checkbox-non-necessary') !== 'null') {
              this.settings.consentGiven = CLI_Cookie.read('cookielawinfo-checkbox-non-necessary') === 'yes';
            }
            if (CLI_Cookie.read('cookielawinfo-checkbox-necessary') !== 'null') {
              this.settings.consentGiven = CLI_Cookie.read('cookielawinfo-checkbox-necessary') === 'yes';
            }
          }
        } else if (typeof window.cnArgs !== "undefined") {
          // Cookie Notice by dFactory
          var value = "; " + document.cookie,
            parts = value.split('; cookie_notice_accepted=');
          if (parts.length === 2) {
            var val = parts.pop().split(';').shift();
            this.settings.consentGiven = val === 'true';
          }
        } else if (typeof window.complianz !== 'undefined') {
          // Complianz by Really Simple Plugins
          this.settings.consentGiven = sbyCmplzGetCookie('cmplz_marketing') === 'allow' || jQuery('body').hasClass('cmplz-status-marketing');
        } else if (typeof window.Cookiebot !== "undefined") {
          // Cookiebot by Cybot A/S
          this.settings.consentGiven = Cookiebot.consented;
        } else if (typeof window.BorlabsCookie !== 'undefined') {
          // Borlabs Cookie by Borlabs
          this.settings.consentGiven = typeof window.BorlabsCookie.Consents !== 'undefined' ? window.BorlabsCookie.Consents.hasConsent('youtube') : window.BorlabsCookie.checkCookieConsent('youtube');
        }
        var evt = jQuery.Event('sbycheckconsent');
        evt.feed = this;
        jQuery(window).trigger(evt);
        if (this.settings.consentGiven) {
          this.settings.noCDN = false;
        }
        return this.settings.consentGiven; // GDPR not enabled
      },
      afterConsentToggled: function afterConsentToggled() {
        if (this.checkConsent()) {
          var feed = this;
          window.sby.maybeAddYTAPI();
          feed.maybeRaiseImageResolution();
          feed.applyFullFeatures();
          setTimeout(function () {
            feed.afterResize();
          }, 500);
        }
      },
      removeFeatures: function removeFeatures() {
        var feed = this;
        if (feed.settings.noCDN) {
          $(feed.el).find('.sby_video_thumbnail').each(function () {
            $(this).removeAttr('data-sby-lightbox');
          });
        }
      },
      applyFullFeatures: function applyFullFeatures() {
        var feed = this;
        $(feed.el).find('.sby_header_img img').attr('src', $(feed.el).find('.sby_header_img').attr('data-avatar-url'));
        if (typeof $(feed.el).find('.sby_video_thumbnail').first().attr('data-sby-lightbox') === 'undefined' && feed.settings.lightboxEnabled) {
          $(feed.el).find('.sby_video_thumbnail').each(function () {
            $(this).attr('data-sby-lightbox', feed.index);
          });
        }
        var $self = $(feed.el);
        $self.find('.sby_no_consent').removeClass('sby_no_consent');
        if ($self.hasClass('sby_layout_gallery') && $self.find('.sby_player_outer_wrap').length) {
          this.maybeRaiseSingleImageResolution($self.find('.sby_player_outer_wrap'), 0, true);
          $self.find('.sby_item').first().addClass('sby_current');
          if (!feed.canCreatePlayer()) {
            return;
          }
          if (!$self.find('.sby_player_outer_wrap iframe').length) {
            feed.createPlayer('sby_player' + feed.index);
          }
        }
      },
      locationGuess: function locationGuess() {
        var $feed = $(this.el),
          location = 'content';
        if ($feed.closest('footer').length) {
          location = 'footer';
        } else if ($feed.closest('.header').length || $feed.closest('header').length) {
          location = 'header';
        } else if ($feed.closest('.sidebar').length || $feed.closest('aside').length) {
          location = 'sidebar';
        }
        return location;
      }
    };
    function SbyFeedPro(el, index, settings) {
      SbyFeed.call(this, el, index, settings);
      this.CTA = {};
      this.initLayout = function () {
        this.initGalleryLayout();
        this.initGrid();
        this.initCarousels();
        var evt = jQuery.Event('sbyafterlayoutinit');
        evt.feed = this;
        jQuery(window).trigger(evt);
        openComments();
      };
      this.initGrid = function () {
        if (window.sbySemiEagerLoading && jQuery('#sby_lightbox').length) {
          var feed = this;
          playerID = 'sby_lb-player';
          jQuery('#sby_lightbox').addClass('sby_video_lightbox');
          if (!window.sbyOptions.isPro) {
            jQuery('#sby_lightbox').addClass('sby_lightbox_free');
          }
          var videoID = $(this.el).find('sby_item').first().attr('data-video-id'),
            autoplay = sbyOptions.autoplay;
          if (typeof window.sbyLightboxPlayer === 'undefined') {
            var args = {
              host: window.location.protocol + feed.embedURL,
              videoId: videoID,
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: autoplay
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
                }
              }
            };
            feed.maybeAddCTA(playerID);
            window.sbyLightboxPlayer = new window.YT.Player(playerID, args);
          }
        }
      };
      this.initCarousels = function () {
        var feed = this,
          $self = $(this.el);
        if (typeof this.settings.general.carousel === 'undefined') {
          return;
        }
        var cols = this.settings.cols,
          colsmobile = this.settings.colsmobile;
        $self.find('.sby_items_wrap').addClass('sby_carousel');
        $self.find('.sby_load_btn').remove();
        $self.find('.sby_item').css({
          'padding-top': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-right': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-bottom': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-left': $self.find('.sby_items_wrap').css('padding-top')
        });
        $self.find('.sby_item').each(function () {
          $(this).attr('style', $(this).attr('style').replace('padding: ' + $self.find('.sby_items_wrap').css('padding-top'), 'padding: ' + $self.find('.sby_items_wrap').css('padding-top') + ' !important'));
        });
        var arrows = feed.settings.general.carousel[0],
          pagination = feed.settings.general.carousel[1],
          autoplay = feed.settings.general.carousel[2],
          time = feed.settings.general.carousel[3],
          loop = feed.settings.general.carousel[4],
          rows = feed.settings.general.carousel[5];
        //Initiate carousel
        if (!autoplay) time = false;

        //Set defaults for responsive breakpoints
        var itemsTabletSmall = cols,
          itemsMobile = cols,
          arrows = arrows ? 'onhover' : 'hide',
          autoplay = time !== false,
          has2rows = rows == 2,
          loop = !loop,
          onChange = function onChange() {
            setTimeout(function () {
              feed.afterResize();
            }, 1);
          },
          afterInit = function afterInit() {
            var $self = jQuery(feed.el);
            $self.find('.sby_items_wrap.sby_carousel').fadeIn();
            setTimeout(function () {
              $self.find('.sby_items_wrap.sby_carousel .sby_info, .sby_owl2row-item,.sby_items_wrap.sby_carousel').fadeIn();
            }, 1);
            setTimeout(function () {
              var $navElementsWrapper = $self.find('.sby-owl-nav');
              if (arrows === 'onhover') {} else if (arrows === 'below') {
                var $dots = $self.find('.sby-owl-dots'),
                  $prev = $self.find('.sby-owl-prev'),
                  $next = $self.find('.sby-owl-next'),
                  $nav = $self.find('.sby-owl-nav'),
                  $dot = $self.find('.sby-owl-dot'),
                  widthDots = $dot.length * $dot.innerWidth(),
                  maxWidth = $self.innerWidth();
                $prev.after($dots);
                $nav.css('position', 'relative');
                $next.css('position', 'absolute').css('top', '-6px').css('right', Math.max(.5 * $nav.innerWidth() - .5 * widthDots - $next.innerWidth() - 6, 0));
                $prev.css('position', 'absolute').css('top', '-6px').css('left', Math.max(.5 * $nav.innerWidth() - .5 * widthDots - $prev.innerWidth() - 6, 0));
              } else if (arrows === 'hide') {
                $navElementsWrapper.addClass('hide').hide();
              }
            }, 1);
          };

        //Disable mobile layout
        if ($self.hasClass('sby_mob_col_auto')) {
          itemsTabletSmall = 2;
          if (parseInt(cols) != 2) itemsMobile = 1;
          if (parseInt(cols) == 2) itemsMobile = 2; //If the cols are set to 2 then don't change to 1 col on mobile
        } else {
          itemsMobile = colsmobile;
        }
        this.carouselArgs = {
          items: cols,
          loop: loop,
          rewind: !loop,
          autoplay: autoplay,
          autoplayTimeout: Math.max(time, 2000),
          autoplayHoverPause: true,
          nav: true,
          navText: ['<svg class="svg-inline--fa fa-chevron-left fa-w-10" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="chevron-left" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M34.52 239.03L228.87 44.69c9.37-9.37 24.57-9.37 33.94 0l22.67 22.67c9.36 9.36 9.37 24.52.04 33.9L131.49 256l154.02 154.75c9.34 9.38 9.32 24.54-.04 33.9l-22.67 22.67c-9.37 9.37-24.57 9.37-33.94 0L34.52 272.97c-9.37-9.37-9.37-24.57 0-33.94z"></path></svg>', '<svg class="svg-inline--fa fa-chevron-right fa-w-10" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="chevron-right" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"></path></svg>'],
          dots: pagination,
          owl2row: has2rows,
          responsive: {
            0: {
              items: itemsMobile
            },
            480: {
              items: itemsTabletSmall
            },
            640: {
              items: cols
            }
          },
          onChange: onChange,
          onInitialize: afterInit
        };
      };
      this.stripEmojihtml = function ($el) {
        $el.find('.emoji').each(function () {
          $(this).replaceWith($(this).attr('alt'));
        });
        return $el.html();
      };
      this.afterItemRevealed = function ($item) {
        var feed = this;
        if ($item.find('.sby_caption').length && !$item.find('.sby_caption').hasClass('sby_full_caption')) {
          //Expand post
          var $caption = $item.find('.sby_item_caption_wrap .sby_caption'),
            $hoverCaption = $item.find('.sby_item_video_thumbnail .sby_caption'),
            text_limit = typeof feed.settings.general.descriptionlength !== 'undefined' ? parseInt(feed.settings.general.descriptionlength) : 150;
          if (text_limit < 1) text_limit = 99999;
          //Set the full text to be the caption (used in the image alt)

          var captionText = this.stripEmojihtml($item.find('.sby_caption').first()),
            brCount = (captionText.match(/<br>/g) || []).length,
            brAdjust = typeof sbyOptions.brAdjust === 'undefined' || sbyOptions.brAdjust === '1' || sbyOptions.brAdjust === true;
          // comment out unnecessary code that stripes out text limit with wrong text limit
          // replace emoji with alt for more accurate shortening
          //                     if (brAdjust && brCount > 0 && captionText.indexOf('<br>') < text_limit) {
          //                         var $sizingCaption = $item.find('.sby_video_title').first();
          //                         captionWidth = $sizingCaption.width() > 20 ? $sizingCaption.width() : $item.width(),
          //                           fontSize = $sizingCaption.css('font-size'),
          //                           charactersPerLine = captionWidth / parseInt(fontSize) * 1.85,
          //                           maxCharsPerLine = Math.floor(charactersPerLine),
          //                           projectedMaxLines = Math.ceil(text_limit / charactersPerLine);
          //                         var splitCaption = captionText.split('<br>'),
          //                           linesConsumed = 0,
          //                           adjustedTextLimit = 0;
          //                         jQuery.each(splitCaption, function () {
          //                             var linesLeft = projectedMaxLines - linesConsumed;
          //                             if (linesLeft > 0) {
          //                                 var thisLinesConsumed = Math.max(1, Math.ceil(this.length / charactersPerLine));
          //                                 adjustedTextLimit += Math.min(this.length + 4, linesLeft * maxCharsPerLine);
          //                                 linesConsumed += thisLinesConsumed;
          //                             }
          //                         });
          //                         text_limit = adjustedTextLimit;
          //                     }
          var short_text = captionText.substring(0, text_limit);
          short_text = captionText.length > text_limit ? short_text.substr(0, Math.min(short_text.length, short_text.lastIndexOf(" "))) : short_text;

          //Cut the text based on limits set
          if ($caption.length) {
            $caption.html(sbyLinkify(short_text));
            if (short_text === captionText) {
              $caption.next('.sby_expand').remove();
            }
          }
          if ($hoverCaption.length) {
            var hoverCaptionText = short_text;
            if (short_text !== captionText) {
              hoverCaptionText += '<span class="sby_more">...</span>';
            }
            $hoverCaption.html(hoverCaptionText);
          }

          //Show the 'See More' link if needed
          if (captionText.length > text_limit) {
            $item.find('.sby_expand').show();
          }
          //Click function
          $item.find('.sby_expand a').off('click').on('click', function (e) {
            e.preventDefault();
            var $expand = jQuery(this);
            $caption = typeof $caption !== 'undefined' ? $caption : $item.find('.sby_info .sby_caption');
            captionText = typeof captiontext !== 'undefined' ? captionText : sbyEncodeInput($item.find('.sby_item_video_thumbnail').attr('data-title'));
            if ($item.hasClass('sby_caption_full') && typeof short_text !== 'undefined') {
              $caption.html(short_text);
              $item.removeClass('sby_caption_full');
            } else {
              $caption.html(sbyLinkify(captionText));
              $item.addClass('sby_caption_full');
            }
            feed.afterResize();
          });
        }
        this.setUpCTA($item);

        //Photo links
        //If lightbox is disabled
        var disablelightbox = typeof feed.settings.general.disablelightbox !== 'undefined' ? feed.settings.general.disablelightbox : false,
          captionlinks = typeof feed.settings.general.captionlinks !== 'undefined' ? feed.settings.general.captionlinks : false;
        if (disablelightbox || captionlinks) {
          if (captionlinks) {
            var sbyUrlDetect = function sbyUrlDetect(text) {
              var urlRegex = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
              return text.match(urlRegex);
            };
            var cap = '';
            if (typeof $item.find('img').attr('alt') !== 'undefined') {
              cap = $item.find('img').attr('alt');
            } else if (typeof $item.find('video').attr('alt') !== 'undefined') {
              cap = $item.find('video').attr('alt');
            }
            var url = sbyUrlDetect(cap);
            if (url) {
              $item.find('a').attr('href', url);
            }
          }
          $item.find('.sby_link').addClass('sby_disable_lightbox');
          //If lightbox is enabled add lightbox links
        } else {
          var $sby_photo_wrap = $item.find('.sby_photo_wrap'),
            $sby_link = $sby_photo_wrap.find('.sby_link');
          feedOptions = {
            hovereffect: 'true'
          };
          if (feedOptions.hovereffect == 'none') {
            //launch lightbox on click
            $sby_link.css('background', 'none').show();
            $sby_link.find('*').hide().end().find('.sby_link_area').show();
          } else {
            $sby_photo_wrap.on('mouseenter mouseleave', function (e) {
              switch (e.type) {
                case 'mouseenter':
                  $item.addClass('sby_animate');
                  break;
                case 'mouseleave':
                  $item.removeClass('sby_animate');
                  break;
              }
            });
          }
        }
        var videoID = typeof $item.attr('data-video-id') !== 'undefined' ? $item.attr('data-video-id') : $item.find('.sby_video_thumbnail').attr('data-video-id');
        this.mostRecentlyLoadedPosts.push(videoID);
      };
      this.afterFeedSet = function () {
        if (typeof this.carouselArgs !== 'undefined') {
          $(this.el).find('.sby_carousel').sbyOwlCarousel(this.carouselArgs);
          if (parseInt(this.settings.general.carousel[5]) === 2) {
            $(this.el).addClass('sby_carousel_2_row');
          }
        }
      };
      this.setUpCTA = function ($item, videoID) {
        //window.sby.ctas

        var videoID = typeof videoID !== 'undefined' ? videoID : $item.find('.sby_item_video_thumbnail').attr('data-video-id'),
          text = sbyEncodeInput(typeof $item.find('.sby_item_video_thumbnail').attr('data-title') !== 'undefined' ? $item.find('.sby_item_video_thumbnail').attr('data-title') : ''),
          ctaInCaption = window.sby.ctaDetect(text);
        if (ctaInCaption) {
          window.sby.ctas[videoID] = ctaInCaption;
        } else {
          window.sby.ctas[videoID] = this.getDefaultCTA();
        }
      };
      this.getDefaultCTA = function () {
        if (typeof this.settings.general.cta !== 'undefined' && this.settings.general.cta.type !== 'default') {
          if (this.settings.general.cta.type === 'link') {
            return {
              callback: 'link',
              url: this.settings.general.cta.defaultLink,
              text: this.settings.general.cta.defaultText
            };
          } else {
            return {
              callback: 'related',
              related: this.settings.general.cta.defaultPosts
            };
          }
        } else {
          return false;
        }
      };
      this.afterResize = function () {
        this.setImageHeight();
        this.setImageResolution();
        this.maybeRaiseImageResolution();
        this.setImageSizeClass();
        this.setAllCTADimensions();
        this.sizePlayer();
        this.sizeItems();
      };
      this.setAllCTADimensions = function () {
        $.each(this.CTA, function (index, CTAObj) {
          if (CTAObj.isInitialized) {
            CTAObj.setCTAStyles();
          }
        });
      };
      this.afterSendCheckWPPostsToServer = function (response) {
        var $self = $(this.el);
        $self.find('.sby_item').each(function () {
          if (typeof response[$(this).attr('data-video-id')] !== 'undefined') {
            var data = response[$(this).attr('data-video-id')];
            //sby_views_count
            $(this).find('.sby_view_count').text(data.sby_view_count);
            $(this).find('.sby_comment_count').text(data.sby_comment_count);
            $(this).find('.sby_like_count').text(data.sby_like_count);

            //Set for attributes too.
            $(this).find('.sby_video_thumbnail').attr('data-views', data.sby_view_count);
            $(this).find('.sby_video_thumbnail').attr('data-comment-count', data.sby_comment_count);
            if (data.sby_live_broadcast.broadcast_type !== 'none') {
              $(this).find('.sby_ls_message').text(data.sby_live_broadcast.live_streaming_string);
              $(this).find('.sby_date').html(data.sby_live_broadcast.live_streaming_date);
            }
            if (typeof data.sby_live_broadcast.live_streaming_timestamp !== 'undefined') {
              $(this).attr('data-live-date', data.sby_live_broadcast.live_streaming_timestamp);
            }
            if (typeof data.sby_description !== 'undefined') {
              $(this).find('.sby_item_video_thumbnail').attr('data-title', sbyEncodeInput(data.sby_description));
            }
          }
        });
        $self.find('.sby_player_item').each(function () {
          if (typeof response[$(this).find('.sby_video_thumbnail').attr('data-video-id')] !== 'undefined') {
            var data = response[$(this).find('.sby_video_thumbnail').attr('data-video-id')];
            $(this).find('.sby_view_count').text(data.sby_view_count);
            $(this).find('.sby_comment_count').text(data.sby_comment_count);
            $(this).find('.sby_like_count').text(data.sby_like_count);
            if (data.sby_live_broadcast.broadcast_type !== 'none') {
              $(this).find('.sby_ls_message').text(data.sby_live_broadcast.live_streaming_string);
              $(this).find('.sby_date').html(data.sby_live_broadcast.live_streaming_date);
            }
            if (typeof data.sby_live_broadcast.live_streaming_timestamp !== 'undefined') {
              $(this).attr('data-live-date', data.sby_live_broadcast.live_streaming_timestamp);
            }
          }
        });
        var evt = jQuery.Event('sbyaftercheckposts');
        evt.feed = window.sby.feeds[index];
        evt.response = response;
        jQuery(window).trigger(evt);
      };
      this.afterStateChange = function (playerID, videoID, data, $player) {
        this.CTA[playerID].toggleCTA(videoID, data.data, $player);
      };
      this.changePlayerInfo = function ($newItem) {
        var $self = $(this.el);
        $self.find('.sby_player_item').find('.sby_info').replaceWith($newItem.find('.sby_info').clone(true, true));
        var videoTitle = checkValue($newItem.attr('data-video-title'));
        var videoPublishData = checkValue($newItem.find('.sby_video_thumbnail').attr('data-formatted-published-date'));
        $self.find('.sby-player-info .sby-video-header-info .sby-video-info-header h5').text(videoTitle);
        $self.find('.sby-player-info .sby-video-header-meta .sby-video-date').text(videoPublishData);
        resetComments($self);
        openComments();
      };
      this.maybeAddCTA = function (playerID, $el) {
        if (typeof this.CTA[playerID] === 'undefined') {
          this.CTA[playerID] = new SbyCTA(playerID, this);
        }
      };
    }
    SbyFeedPro.prototype = Object.create(SbyFeed.prototype);
    function SbyLightboxBuilder() {}
    SbyLightboxBuilder.prototype = {
      getData: function getData(a) {
        var closestFeedIndex = parseInt(a.closest('.sb_youtube').attr('data-sby-index') - 1);
        return {
          feedIndex: closestFeedIndex,
          link: a.attr("href"),
          videoTitle: typeof a.attr("data-video-title") !== 'undefined' ? sbyEncodeInput(a.attr("data-video-title")) : 'YouTube Video',
          video: a.attr("data-video-id"),
          channelID: a.attr("data-channel-id")
        };
      },
      template: function template() {
        return "<div id='sby_lightboxOverlay' class='sby_lightboxOverlay'></div>" + "<div id='sby_lightbox' class='sby_lightbox'>" + "<div class='sby_lb-outerContainer'>" + "<div class='sby_lb-container'>" + "<img class='sby_lb-image' alt='Lightbox image placeholder' src='' />" + "<div class='sby_lb-player sby_lb-player-placeholder' id='sby_lb-player'></div>" + "<div class='sby_lb-nav'><a class='sby_lb-prev' href='#' ><p class='sby-screenreader'>Previous Slide</p><span></span></a><a class='sby_lb-next' href='#' ><p class='sby-screenreader'>Next Slide</p><span></span></a></div>" + "<div class='sby_lb-loader'><a class='sby_lb-cancel'></a></div>" + "</div>" + "</div>" + "<div class='sby_lb-dataContainer'>" + "<div class='sby_lb-data'>" + "<div class='sby_lb-details'>" + "<div class='sby_lb-caption'></div>" + "<div class='sby_lb-info'>" + "<div class='sby_lb-number'></div>" + "</div>" + "</div>" + "<div class='sby_lb-closeContainer'><a class='sby_lb-close'></a></div>" + "</div>" + "</div>" + "</div>";
      },
      beforePlayerSetup: function beforePlayerSetup($lightbox, data, index, album, feed) {},
      afterPlayerSetup: function afterPlayerSetup($lightbox, data, index, album) {},
      afterResize: function afterResize() {
        var playerHeight = $('#sby_lightbox .sby_lb-player').height();
        if (playerHeight > 100) {
          var heightDif = $('#sby_lightbox .sby_lb-outerContainer').height() - playerHeight;
          if (heightDif > 10) {
            $('#sby_lightbox .sby_lb-player').css('top', heightDif / 2);
          }
        }
      },
      pausePlayer: function pausePlayer() {
        if (typeof window.sbyLightboxPlayer === 'undefined' && typeof YT === 'undefined') {
          return;
        }
        if (typeof YT.get('sby_lb-player') !== 'undefined' && typeof YT.get('sby_lb-player').pauseVideo === 'function') {
          YT.get('sby_lb-player').pauseVideo();
        } else if (typeof window.sbyLightboxPlayer !== 'undefined' && typeof window.sbyLightboxPlayer.pauseVideo === 'function') {
          window.sbyLightboxPlayer.pauseVideo();
        }
      }
    };
    SbyLightboxBuilderPro.prototype = Object.create(SbyLightboxBuilder.prototype);
    function SbyLightboxBuilderPro() {
      SbyLightboxBuilder.call(this);
      this.getData = function (a) {
        var feedParent = a.closest('.sb_youtube');
        var closestFeedIndex = parseInt(feedParent.attr('data-sby-index') - 1);
        var subscribeBtnText = feedParent.attr('data-subscribe-btn-text');
        var subscribeBtn = feedParent.attr('data-subscribe-btn');
        var colorScheme = feedParent.hasClass('sby_palette_dark') ? 'dark' : 'light';
        var atts = feedParent.attr('data-shortcode-atts');
        var liveDataAttr = a.closest('.sby_item').attr('data-live-date');
        var channelHeaderColorsAttr = feedParent.attr('data_channel_header_colors') ? JSON.parse(feedParent.attr('data_channel_header_colors')) : '';
        return {
          feedIndex: closestFeedIndex,
          link: a.attr("href"),
          video: a.attr("data-video-id"),
          title: sbyEncodeInput(a.attr("data-title")),
          videoTitle: typeof a.attr("data-video-title") !== 'undefined' ? sbyEncodeInput(a.attr("data-video-title")) : 'YouTube Video',
          avatar: a.attr("data-avatar"),
          user: sbyEncodeInput(a.attr("data-user")),
          channelURL: a.attr("data-url"),
          channelID: a.attr("data-channel-id"),
          channelSubscribers: a.closest('.sb_youtube').attr('data-channel-subscribers'),
          subscribeBtn: subscribeBtn,
          subscribeBtnText: subscribeBtnText,
          colorScheme: colorScheme,
          publishedDate: a.attr("data-published-date"),
          commentCount: a.attr("data-comment-count"),
          views: a.attr("data-views"),
          liveData: liveDataAttr,
          channelHeaderColors: channelHeaderColorsAttr,
          atts: atts
        };
      };
      this.template = function () {
        return "\n                <div id='sby_lightboxOverlay' class='sby_lightboxOverlay'></div>\n                <div id='sby_lightbox' class='sby_lightbox'>\n                 <div class='sby_lb-header'></div>\n                  <div class='sby_lb-outerContainer'>\n                    <a class='sby_lb-close'></a>\n                    <div class='sby_lb-container'>\n                      <div class='sby_lb_video_thumbnail_wrap'>\n                        <span class='sby_lb_video_thumbnail'>\n                          <img class='sby_lb-image' alt='Lightbox image placeholder' src='' />\n                          <div class='sby_lb-player' id='sby_lb-player'></div>\n                        </span>\n                      </div>\n                      <div class='sby_lb-nav'>\n                        <a class='sby_lb-prev' href='#'>\n                          <p class='sby-screenreader'>Previous Slide</p>\n                          <span></span>\n                        </a>\n                        <a class='sby_lb-next' href='#'>\n                          <p class='sby-screenreader'>Next Slide</p>\n                          <span></span>\n                        </a>\n                      </div>\n                      <div class='sby_lb-loader'>\n                        <a class='sby_lb-cancel'></a>\n                      </div>\n                    </div>\n                  </div>\n                  <div class='sby_lb-dataContainer'>\n                    <div class='sby_lb-data'>\n                      <div class='sby_lb-details'>\n                        <div class='sby_lb-caption'>\n                        </div>\n                        <div class='sby_lb-info'>\n                          <div class='sby_lb-number'></div>\n                        </div>\n                      </div>\n                    </div>\n                  </div>\n                </div>";
      };
      this.beforePlayerSetup = function ($lightbox, data, index, album, feed) {
        $('body').css('overflow', 'hidden');
        if (!$lightbox.find('.sby_cta_items_wraps').length) {
          $lightbox.find('.sby_lb_video_thumbnail_wrap').append($(feed.el).find('.sby_cta_items_wraps').clone());
        } else {
          $lightbox.find('.sby_cta_items_wraps').replaceWith($(feed.el).find('.sby_cta_items_wraps').clone());
        }
      };
      this.afterPlayerSetup = function ($lightbox, data, index, album) {
        var _data$channelSubscrib;
        this.availableAvatarUrls = {};
        var subscribeSection = data !== null && data !== void 0 && data.subscribeBtn ? data.subscribeBtn : false;
        var subscribeBtnText = data !== null && data !== void 0 && data.subscribeBtnText ? data.subscribeBtnText : '';
        if (typeof sbyLightboxAction === 'function') {
          setTimeout(function () {
            sbyLightboxAction();
          }, 100);
        }
        if (data !== null && data !== void 0 && data.colorScheme && 'dark' === data.colorScheme) {
          LightboxColorScheme(data.colorScheme, true);
        }
        var avatarImage = '',
          subscribeBtn = subscribeSection ? '<a class="sby-lb-subscribe-btn" href="http://www.youtube.com/channel/' + data.channelID + '?sub_confirmation=1&feature=subscribe-embed-click" target="_blank" rel="noopener noreferrer">' + getStaticSVG('youtube') + ' <p>' + subscribeBtnText + '</p></a>' : '';
        if (typeof data.avatar !== 'undefined' && data.avatar !== '' && typeof data.user !== 'undefined') {
          avatarImage = data.avatar !== 'undefined' ? data.avatar : '';
        } else if (typeof data.user !== 'undefined') {
          jQuery.each(window.sby.feeds, function () {
            if (typeof this.availableAvatarUrls !== 'undefined' && typeof this.availableAvatarUrls[data.user] !== 'undefined' && this.availableAvatarUrls[data.user] !== 'undefined') {
              avatarImage = this.availableAvatarUrls[data.user];
            }
          });
        }
        var channelSubscribers = (_data$channelSubscrib = data === null || data === void 0 ? void 0 : data.channelSubscribers) !== null && _data$channelSubscrib !== void 0 ? _data$channelSubscrib : '';
        var avatarImageHtml = avatarImage ? '<img src="' + avatarImage + '" referrerPolicy="no-referrer"/>' : getStaticSVG('profile-picture');
        var userHtml = subscribeSection && avatarImage ? '<div class="sby-lb-channel-header"><a class="sby_lightbox_username" href="' + data.channelURL + '" target="_blank" rel="noopener">' + avatarImageHtml + '<p class="sby-lb-channel-name-with-subs"><span>@' + data.user + '</span><span>' + channelSubscribers + '</span></p></a> ' + subscribeBtn + '</div>' : '';
        var subscribeClass = subscribeSection && avatarImage ? 'sby_lb-channel-info' : 'sby_lb-no-channel-info';
        if (window.sbyOptions.isPro) {
          var description = data !== null && data !== void 0 && data.title ? addLinksTotext(data.title) : '';
          var publishedDate = data !== null && data !== void 0 && data.publishedDate ? timeAgo(convertUnixToMs(data.publishedDate)) : '';
          var views = data !== null && data !== void 0 && data.views ? data.views : '';
          var videoHeaderSection = "\n                    <div class=\"sby_lb-video-heading\">\n                        <h3>".concat(data.videoTitle, "</h3>\n                        <div class=\"sby_lb-video-info\">\n                            <span>").concat(views, "</span>\n                            <span class=\"sby_lb-spacer\">\xB7</span>\n                            <span>").concat(publishedDate, "</span>\n                        </div>\n                    </div>\n                ");
          var videoDescriptionhtml = "\n                    <div class=\"sby_lb-video-description-wrap\">\n                        <div class=\"sby_lb-description sby-read-more-target\">\n                            ".concat(description, "\n                        </div>\n                        <button class=\"sby_lb-more-info-btn sby-read-more-trigger\">Description").concat(getStaticSVG('angle-down'), "</button>\n                    </div>\n                ");
          var commentSectionHtml = "\n                    <div class=\"sby-comments-wrap\">\n                    </div>\n                ";
          var videoDescription = description ? videoDescriptionhtml : '';
          $lightbox.find(".sby_lb-caption").html("<div class=\"sby_lb-caption-inner ".concat(subscribeClass, "\">") + videoHeaderSection + userHtml + videoDescription + commentSectionHtml + "</div>").fadeIn("fast");
          if (data !== null && data !== void 0 && data.liveData && '0' === data.liveData) {
            var videoId = data !== null && data !== void 0 && data.video ? data.video : '';
            var atts = data !== null && data !== void 0 && data.atts ? data.atts : '';
            var _currentCommentCount = data !== null && data !== void 0 && data.commentCount ? data.commentCount : '';
            var target = $lightbox.find(".sby-comments-wrap");
            generateCommentSection(videoId, atts, target, _currentCommentCount);
          } else {
            toggleReadMore();
          }
          if (data !== null && data !== void 0 && data.channelHeaderColors) {
            setColorsToChannelHeader(data.channelHeaderColors);
          }
        }
      };
    }
    function SbyCTA(videoID, feed) {
      this.isInitialized = false;
      this.videoID = videoID;
      this.callback = this.related;
      this.callbackArgs = {};
      this.feedObjInContext = feed;
      this.state = 1;
      this.numItems = 4;
      this.numItemColumns = 2;
      this.$player = false;
    }
    SbyCTA.prototype = {
      toggleCTA: function toggleCTA(videoID, dataNum, $player) {
        this.$player = $player.length ? $player : $('.sby_lb-container'); // use the lightbox container if no player is set
        this.state = dataNum;
        this.videoID = videoID;
        this.isInitialized = true;
        this.resetCTA();

        //ctaDetect

        if (typeof window.sby.ctas[videoID] !== 'undefined') {
          this.callbackArgs = window.sby.ctas[videoID];
        }
        var callback = this.callbackArgs.callback;
        if (callback === 'link') {
          this.callback = this.link;
        } else if (callback === 'related') {
          this.callback = this.related;
        } else {
          return;
        }
        if (dataNum === 2 || dataNum === 0) {
          this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_is_open');
          if (dataNum === 2) {
            this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_state_paused');
          } else {
            this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_state_ended');
          }
          this.$player.find('.sby_cta_items_wraps').show();
          this.callback();
          this.setCTAStyles();
        } else {
          this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_is_open');
          this.$player.find('.sby_cta_items_wraps').hide().removeClass('sby_cta_state_paused').removeClass('sby_cta_state_ended').removeClass('sby_cta_is_open');
        }
      },
      related: function related(args) {
        var ctaObj = this,
          feedObjInContext = this.feedObjInContext,
          related = window.sby.shuffle(this.getRelated(feedObjInContext)),
          added = 0,
          currentVideoId = this.videoID,
          $player = this.$player;
        this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_cols_' + this.numItemColumns);
        this.numItems = 4;
        this.numItemColumns = 2;
        if ($player.width() < 480) {
          this.numItems = 1;
          this.numItemColumns = 1;
        }
        var numItems = this.numItems;
        $.each(related, function (index, value) {
          if (value.videoID !== currentVideoId && added < numItems) {
            $player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').append('<div class="sby_cta_item"><div class="sby_video_thumbnail_wrap">' + '<a class="sby_video_thumbnail" href="javascript:void(0);" target="_blank" rel="noopener" data-video-id="' + value.videoID + '">' + '<div class="sby_thumbnail_hover">' + '<div class="sby_thumbnail_hover_inner">' + '<span class="sby_video_title">' + value.title + '</span>' + '</div>' + '</div>' + '<span class="sby-screenreader">Play</span>' + '<img src="' + value.thumbnail + '" alt="' + value.title + '">' + '<span class="sby_loader sby_hidden" style="background-color: rgb(255, 255, 255);"></span>' + '</a>' + '</div>' + '</div>');
            added++;
          }
        });
        $player.find('.sby_cta_items_wraps .sby_video_thumbnail').each(function () {
          $(this).off().on('click', function (event) {
            event.preventDefault();
            var newVideoID = $(this).attr('data-video-id');
            feedObjInContext.onThumbnailClick($(this), true, newVideoID);
            ctaObj.videoID = newVideoID;
          });
        });
      },
      getRelated: function getRelated(feedObjInContext) {
        if (typeof feedObjInContext.settings.general.cta.defaultPosts[0] === 'undefined') {
          var $feedEl = $(feedObjInContext.el),
            relatedVids = [];
          $feedEl.find('.sby_item').each(function () {
            if (typeof $(this).find('.sby_item_video_thumbnail').attr('data-full-res') !== 'undefined') {
              var thisVid = {
                videoID: $(this).attr('data-video-id'),
                title: sbyEncodeInput($(this).attr('data-video-title')),
                thumbnail: $(this).find('.sby_item_video_thumbnail').attr('data-full-res')
              };
              relatedVids.push(thisVid);
            }
          });
          return relatedVids;
        }
        return feedObjInContext.settings.general.cta.defaultPosts;
      },
      link: function link(args) {
        var $player = this.$player,
          feedObjInContext = this.feedObjInContext;
        this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_cols_' + this.numItemColumns);
        this.numItems = 1;
        this.numItemColumns = 1;
        var style = '',
          styleClass = '';
        if (feedObjInContext.settings.general.cta.color !== '' || feedObjInContext.settings.general.cta.textColor !== '') {
          style = ' style="';
          styleClass = ' sby_custom';
          if (feedObjInContext.settings.general.cta.color !== '') {
            style += 'background: rgb(' + feedObjInContext.settings.general.cta.color + ');';
          }
          if (feedObjInContext.settings.general.cta.textColor !== '') {
            style += 'color: rgb(' + feedObjInContext.settings.general.cta.textColor + ');';
          }
          style += '"';
        }
        var openAtts = '';
        if (feedObjInContext.settings.general.cta.openType === 'newwindow') {
          openAtts = ' target="_blank" rel="noopener"';
        }
        $player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').append('<div class="sby_cta_item">' + '<div class="sby_btn_wrap">' + '<div class="sby_btn' + styleClass + '">' + '<a class="sby_cta_button" href="' + this.callbackArgs.url + '"' + openAtts + ' data-video-id="' + this.videoID + '"' + style + '>' + this.callbackArgs.text + '</a>' + '</div>' + '</div>' + '</div>');
      },
      setCTAStyles: function setCTAStyles() {
        var playerTopHeight = 60,
          playerBottomHeight = 49,
          minimumHeight = 90,
          ctaOverlayHeight = Math.max(minimumHeight, this.$player.height() - playerTopHeight - playerBottomHeight);
        this.$player.find('.sby_cta_items_wraps').css('height', ctaOverlayHeight + 'px').css('width', this.$player.find('iframe').width() - 20 + 'px').addClass('sby_cta_cols_' + this.numItemColumns);
        var numRows = Math.max(1, this.numItems / this.numItemColumns),
          totalVerticalPadding = parseInt(this.$player.find('.sby_cta_items_wraps').css('padding-top').replace('px', '')) * 2,
          maxCTAItemHeight = Math.max(minimumHeight, (ctaOverlayHeight - totalVerticalPadding) / numRows);
        this.$player.find('.sby_cta_item').css('max-height', maxCTAItemHeight + 'px').find('img').css({
          'max-height': maxCTAItemHeight + 'px',
          'width': 'auto',
          'margin': 'auto'
        });
        this.$player.find('.sby_btn_wrap').css('height', maxCTAItemHeight + 'px');
      },
      resetCTA: function resetCTA() {
        this.$player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').empty();
      }
    };
    window.sby_init = function () {
      window.sby = new Sby();
      window.sby.createPage(window.sby.createFeeds, {
        whenFeedsCreated: window.sby.afterFeedsCreated
      });
    };
    window.sby_carousel_init = function () {
      console.log('log');
    };
    function sbyGetNewFeed(feed, index, feedOptions) {
      return new SbyFeedPro(feed, index, feedOptions);
    }
    function sbyGetlightboxBuilder() {
      return new SbyLightboxBuilderPro();
    }
    function sbyIsTouch() {
      if ("ontouchstart" in document.documentElement) {
        return true;
      }
      return false;
    }
    function sbyCmplzGetCookie(cname) {
      var name = cname + "="; //Create the cookie name variable with cookie name concatenate with = sign
      var cArr = window.document.cookie.split(';'); //Create cookie array by split the cookie by ';'

      //Loop through the cookies and return the cookie value if it find the cookie name
      for (var i = 0; i < cArr.length; i++) {
        var c = cArr[i].trim();
        //If the name is the cookie string at position 0, we found the cookie and return the cookie value
        if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
      }
      return "";
    }
  })(jQuery);
  if (typeof window.sbyEagerLoading === 'undefined') {
    window.sbyEagerLoading = typeof window.sbyOptions !== 'undefined' ? window.sbyOptions.eagerload : false;
    if (jQuery('.elementor-widget-video').length) {
      var settings = typeof jQuery('.elementor-widget-video').attr('data-settings') !== 'undefined' ? JSON.parse(jQuery('.elementor-widget-video').attr('data-settings')) : false;
      if (settings && typeof settings.youtube_url !== 'undefined') {
        window.sbyEagerLoading = true;
      }
    }
    if (jQuery('div[data-vc-video-bg]').length) {
      window.sbyEagerLoading = true;
    }
  }
  if (typeof window.sbySemiEagerLoading === 'undefined') {
    window.sbySemiEagerLoading = typeof window.sbyOptions !== 'undefined' ? window.sbyOptions.semiEagerload : false;
    if (jQuery('div[data-vc-video-bg]').length || window.sbyEagerLoading) {
      window.sbySemiEagerLoading = false;
    }
  }
  jQuery(document).ready(function ($) {
    if (!window.sbySemiEagerLoading) {
      sby_init();
    }

    // Cookie Notice by dFactory
    $('#cookie-notice a').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // Cookie Notice by dFactory
    $('#cookie-law-info-bar a').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // GDPR Cookie Consent by WebToffee
    $('.cli-user-preference-checkbox').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = false;
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // Cookiebot
    $(window).on('CookiebotOnAccept', function (event) {
      $.each(window.sby.feeds, function (index) {
        window.sby.feeds[index].settings.consentGiven = true;
        window.sby.feeds[index].afterConsentToggled();
      });
    });

    // Complianz by Really Simple Plugins
    document.addEventListener('cmplz_status_change', function (e) {
      if (e.detail.category === 'marketing' && e.detail.value === 'allow') {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = true;
          window.sby.feeds[index].afterConsentToggled();
        });
      }
    });
    $(document).on('cmplzFireCategories', function (event) {
      if (event.detail.category === 'marketing') {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = true;
          window.sby.feeds[index].afterConsentToggled();
        });
      }
    });

    // Borlabs Cookie by Borlabs
    $(document).on('borlabs-cookie-consent-saved', function (event) {
      $.each(window.sby.feeds, function (index) {
        window.sby.feeds[index].settings.consentGiven = false;
        window.sby.feeds[index].afterConsentToggled();
      });
    });

    // hide notice on click and send ajax request to backend
    $('#sby-frce-hide-license-error').on('click', function () {
      $('#sby-fr-ce-license-error').slideUp();
      jQuery.ajax({
        url: sbyOptions.adminAjaxUrl,
        type: 'post',
        data: {
          action: 'sby_hide_frontend_license_error',
          nonce: sbyOptions.nonce
        },
        success: function success(msg) {
          console.log(msg);
        }
      });
    });
  });
} // if sby_js_exists

if (window.sbySemiEagerLoading) {
  var sbyYScriptId = "sby-youtube-api";
  var sbyYScript = document.getElementById(sbyYScriptId);
  if (sbyYScript === null) {
    var tag = document.createElement("script");
    var firstScript = document.getElementsByTagName("script")[0];
    tag.src = "https://www.youtube.com/iframe_api";
    tag.id = sbyYScriptId;
    firstScript.parentNode.insertBefore(tag, firstScript);
  }
}
window.onYouTubeIframeAPIReady = function () {
  var numFeeds = document.getElementsByClassName('sb_youtube').length;
  if (numFeeds > 0) {
    if (window.sbySemiEagerLoading) {
      if (typeof window.sby !== 'undefined') {
        for (var i = 0; i < numFeeds; i++) {
          window.sby.feeds[i].playerAPIReady = true;
        }
      } else {
        window.sbyAPIReady = true;
      }
      sby_init();
    } else {
      if (window.sbyEagerLoading) {
        var flagLightbox = false,
          autoplay = false;
        jQuery('.sb_youtube').each(function (index) {
          var $self = jQuery(this);
          if ($self.hasClass('sby_layout_list')) {
            jQuery(this).addClass('sby_player_loaded');
            $self.find('.sby_item').each(function () {
              videoID = jQuery(this).attr('data-video-id');
              //this.createPlayer(,videoID,0);
              player = new YT.Player('sby_player_' + videoID, {
                height: '100',
                width: '100',
                videoId: videoID,
                playerVars: {
                  modestbranding: 1,
                  rel: 0,
                  autoplay: autoplay
                },
                events: {
                  'onStateChange': function onStateChange(data) {
                    var videoID = data.target.getVideoData()['video_id'];
                    if (data.data !== 1) return;
                    $self.find('.sby_item').each(function () {
                      var itemVidID = jQuery(this).attr('data-video-id');
                      if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                        YT.get('sby_player_' + itemVidID).pauseVideo();
                      }
                    });
                  }
                }
              });
            });
          } else if ($self.hasClass('sby_layout_gallery')) {
            jQuery(this).addClass('sby_player_loaded');
            player = new YT.Player('sby_player' + index, {
              height: '100',
              width: '100',
              videoId: jQuery(this).find('.sby_item').first().attr('data-video-id'),
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: autoplay
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  if (data.data !== 1) return;
                  $self.find('.sby_item').each(function () {
                    var itemVidID = jQuery(this).attr('data-video-id');
                    if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                      YT.get('sby_player_' + itemVidID).pauseVideo();
                    }
                  });
                }
              }
            });
          } else {
            flagLightbox = true;
          }
        });
      } else if (typeof window.sby !== 'undefined') {
        for (var i = 0; i < numFeeds; i++) {
          window.sby.feeds[i].playerAPIReady = true;
        }
      } else {
        window.sbyAPIReady = true;
      }
    }
    jQuery('.sb_youtube').each(function (index) {
      var $self = jQuery(this);
      if ($self.find('.sby_live_player').length) {
        player = new YT.Player($self.find('.sby_live_player').attr('id'), {
          events: {
            'onReady': function onReady() {
              $self.find('.sby_live_player').hide();
              $self.find('.sby_item').remove();
              var videoID = YT.get($self.find('.sby_live_player').attr('id')).getVideoData().video_id;
              $self.find('.sby_player_video_thumbnail').attr('data-video-id', videoID).css('z-index', -1);
              var itemOffset = $self.find('.sby_item').length,
                submitData = {
                  action: 'sby_live_retrieve',
                  video_id: videoID,
                  feed_id: $self.attr('data-feedid'),
                  atts: $self.attr('data-shortcode-atts')
                };
              var onSuccess = function onSuccess(data) {
                if (data.trim().indexOf('{') === 0) {
                  var feed = window.sby.feeds[index],
                    response = JSON.parse(data),
                    checkWPPosts = typeof response.feedStatus.checkWPPosts !== 'undefined' ? response.feedStatus.checkWPPosts : false;
                  if (feed.settings.debugEnabled) {
                    console.log(response);
                  }
                  if (checkWPPosts) {
                    feed.settings.checkWPPosts = true;
                  } else {
                    feed.settings.checkWPPosts = false;
                  }
                  feed.appendNewPosts(response.html);
                  feed.addResizedImages(response.resizedImages);
                  feed.afterInitialImagesLoaded();
                  if (!response.feedStatus.shouldPaginate) {
                    feed.outOfPages = true;
                    $self.find('.sby_load_btn').hide();
                  } else {
                    feed.outOfPages = false;
                  }
                  jQuery('.sby_no_js').removeClass('sby_no_js');
                  $self.find('.sby_live_player').remove();
                  if ($self.hasClass('sby_layout_gallery')) {
                    feed.createPlayer('sby_player' + feed.index);
                  }
                  $self.find('.sby_player_item').css('opacity', 1);
                  $self.find('.sby_item').css('opacity', 1);
                  $self.find('.sby_player_loading').removeClass('sby_player_loading');
                  if ($self.hasClass('sby_layout_list')) {
                    $self.find('.sby_item_video_thumbnail').on('mouseenter', function () {
                      jQuery(this).css('z-index', -1);
                    });
                  }
                }
              };
              jQuery.ajax({
                url: sbyOptions.adminAjaxUrl,
                type: 'post',
                data: submitData,
                success: onSuccess
              });
            }
          }
        });
      }
    });
    if (flagLightbox) {
      if (!jQuery('#sby_lb-player').length) {
        jQuery('.sb_youtube').first().append('<div class="sby_lb-player-loaded sby_lb-player" id="sby_lb-player" style="display: none;"></div>');
      }
      player = new YT.Player('sby_lb-player', {
        height: '100',
        width: '100',
        videoId: jQuery(this).find('.sby_item').first().attr('data-video-id'),
        playerVars: {
          modestbranding: 1,
          rel: 0,
          autoplay: autoplay
        }
      });
      window.sbyLightboxPlayer = player;
    }
  }
  if (typeof window.sby !== 'undefined') {
    var evt = jQuery.Event('sbyfeedandytready');
    jQuery(window).trigger(evt);
  }
};

/**
 * Retrieves a specific attribute value from the given API data object.
 * 
 * @param {Object} rootPath
 * @param {string} attrName
 * 
 * @returns {string|boolean}
 */

function getSingleApiData(rootPath, attrName) {
  var _rootPath$snippet, _rootPath$snippet2, _rootPath$snippet3, _rootPath$snippet4, _rootPath$snippet5, _rootPath$snippet6;
  switch (attrName) {
    case 'authorProfileImageUrl':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet = rootPath.snippet) !== null && _rootPath$snippet !== void 0 && _rootPath$snippet.authorProfileImageUrl ? rootPath.snippet.authorProfileImageUrl : '';
    case 'authorDisplayName':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet2 = rootPath.snippet) !== null && _rootPath$snippet2 !== void 0 && _rootPath$snippet2.authorDisplayName ? rootPath.snippet.authorDisplayName : '';
    case 'authorChannelUrl':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet3 = rootPath.snippet) !== null && _rootPath$snippet3 !== void 0 && _rootPath$snippet3.authorChannelUrl ? rootPath.snippet.authorChannelUrl : '';
    case 'textDisplay':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet4 = rootPath.snippet) !== null && _rootPath$snippet4 !== void 0 && _rootPath$snippet4.textDisplay ? rootPath.snippet.textDisplay : '';
    case 'likeCount':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet5 = rootPath.snippet) !== null && _rootPath$snippet5 !== void 0 && _rootPath$snippet5.likeCount ? rootPath.snippet.likeCount : '';
    case 'publishedAt':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet6 = rootPath.snippet) !== null && _rootPath$snippet6 !== void 0 && _rootPath$snippet6.publishedAt ? rootPath.snippet.publishedAt : '';
    case 'totalReplyCount':
      return rootPath !== null && rootPath !== void 0 && rootPath.totalReplyCount ? rootPath.totalReplyCount : '';
    default:
      return false;
  }
}

/**
 * Retrieves a static SVG image based on the provided name.
 * @param {string} name 
 * @returns {string|boolean} 
 */
function getStaticSVG(name) {
  switch (name) {
    case 'profile-picture':
      return '<svg fill="currentColor" width="800px" height="800px" viewBox="0 0 512 512" id="_x30_1" version="1.1" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M256,0C114.615,0,0,114.615,0,256s114.615,256,256,256s256-114.615,256-256S397.385,0,256,0z M256,90  c37.02,0,67.031,35.468,67.031,79.219S293.02,248.438,256,248.438s-67.031-35.468-67.031-79.219S218.98,90,256,90z M369.46,402  H142.54c-11.378,0-20.602-9.224-20.602-20.602C121.938,328.159,181.959,285,256,285s134.062,43.159,134.062,96.398  C390.062,392.776,380.839,402,369.46,402z"/></svg>';
    case 'thumbs-up':
      return '<svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.4159 4.18027C13.761 4.18027 14.0778 4.32177 14.3664 4.60477C14.6549 4.88777 14.7992 5.20738 14.7992 5.5636V6.2706C14.7992 6.36471 14.7902 6.45188 14.7722 6.5321C14.7542 6.61232 14.7272 6.69266 14.6912 6.7731L12.684 11.4908C12.5845 11.7449 12.4181 11.9486 12.1849 12.1019C11.9517 12.2552 11.69 12.3318 11.3999 12.3318H5.15938C4.77282 12.3318 4.44566 12.2006 4.17788 11.9383C3.90999 11.6759 3.77604 11.346 3.77604 10.9484V4.7561C3.77604 4.56277 3.81332 4.38049 3.88788 4.20927C3.96254 4.03804 4.06477 3.88754 4.19454 3.75777L7.28938 0.662932C7.5186 0.431043 7.79427 0.281321 8.11638 0.213765C8.43849 0.146321 8.71416 0.178988 8.94338 0.311765C9.22549 0.46421 9.40932 0.695932 9.49488 1.00693C9.58032 1.31793 9.58999 1.62804 9.52388 1.93727L9.09554 4.18027H13.4159ZM1.34404 12.3318C1.01393 12.3318 0.726767 12.2097 0.482544 11.9654C0.238322 11.7212 0.116211 11.434 0.116211 11.1039V5.40827C0.116211 5.07804 0.236989 4.79082 0.478544 4.5466C0.7201 4.30238 1.00466 4.18027 1.33221 4.18027H1.34804C1.67827 4.18027 1.96549 4.30238 2.20971 4.5466C2.45393 4.79082 2.57604 5.07804 2.57604 5.40827V11.1039C2.57604 11.434 2.45393 11.7212 2.20971 11.9654C1.96549 12.2097 1.67827 12.3318 1.34804 12.3318H1.34404Z" fill="currentColor"/></svg>';
    case 'angle-down':
      return '<svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.94 0.726654L4 3.77999L7.06 0.726654L8 1.66665L4 5.66665L0 1.66665L0.94 0.726654Z" fill="currentColor"/></svg>';
    case 'youtube':
      return '<svg width="14" height="11" viewBox="0 0 14 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.66671 7.5L9.12671 5.5L5.66671 3.5V7.5ZM13.3734 2.28C13.46 2.59334 13.52 3.01334 13.56 3.54667C13.6067 4.08 13.6267 4.54 13.6267 4.94L13.6667 5.5C13.6667 6.96 13.56 8.03334 13.3734 8.72C13.2067 9.32 12.82 9.70667 12.22 9.87334C11.9067 9.96 11.3334 10.02 10.4534 10.06C9.58671 10.1067 8.79337 10.1267 8.06004 10.1267L7.00004 10.1667C4.20671 10.1667 2.46671 10.06 1.78004 9.87334C1.18004 9.70667 0.793374 9.32 0.626707 8.72C0.540041 8.40667 0.480041 7.98667 0.440041 7.45334C0.393374 6.92 0.373374 6.46 0.373374 6.06L0.333374 5.5C0.333374 4.04 0.440041 2.96667 0.626707 2.28C0.793374 1.68 1.18004 1.29334 1.78004 1.12667C2.09337 1.04 2.66671 0.980002 3.54671 0.940002C4.41337 0.893336 5.20671 0.873336 5.94004 0.873336L7.00004 0.833336C9.79337 0.833336 11.5334 0.940003 12.22 1.12667C12.82 1.29334 13.2067 1.68 13.3734 2.28Z" fill="currentColor"/></svg>';
    case 'cross':
      return '<svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.25 1.41L12.84 0L7.25 5.59L1.66 0L0.25 1.41L5.84 7L0.25 12.59L1.66 14L7.25 8.41L12.84 14L14.25 12.59L8.66 7L14.25 1.41Z" fill="currentColor"/></svg>';
    case 'message':
      return '<svg width="28" height="26" viewBox="0 0 28 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.33341 22C2.60008 22 1.9723 21.7389 1.45008 21.2167C0.927859 20.6944 0.666748 20.0667 0.666748 19.3333V3.33334C0.666748 2.6 0.927859 1.97223 1.45008 1.45001C1.9723 0.927783 2.60008 0.666672 3.33341 0.666672H24.6667C25.4001 0.666672 26.0279 0.927783 26.5501 1.45001C27.0723 1.97223 27.3334 2.6 27.3334 3.33334V24.1C27.3334 24.7 27.0612 25.1167 26.5167 25.35C25.9723 25.5833 25.489 25.4889 25.0667 25.0667L22.0001 22H3.33341ZM23.1334 19.3333L24.6667 20.8333V3.33334H3.33341V19.3333H23.1334Z" fill="currentColor"/></svg>';
    default:
      return false;
  }
}

/**
 * Generates the HTML template for a single comment.
 * 
 * @param {string} authorProfileImageUrl
 * @param {string} authorDisplayName
 * @param {string} authorChannelUrl
 * @param {string} textDisplay
 * @param {number} likeCount
 * @param {string} publishedAt
 * @param {number} totalReplyCount
 * 
 * @returns {string}
 */
function commentSingleTemplate(authorProfileImageUrl, authorDisplayName, authorChannelUrl, textDisplay, likeCount, publishedAt, totalReplyCount) {
  var dummyProfilePic = authorProfileImageUrl ? "<img src=".concat(authorProfileImageUrl, " loading=\"lazy\" referrerPolicy=\"no-referrer\"/>") : getStaticSVG('profile-picture');
  var replies = totalReplyCount ? "<button class=\"sby-replies\">".concat(totalReplyCount ? totalReplyCount : 0, " Replies ").concat(getStaticSVG('angle-down'), "</button>") : '';
  return "\n            <div class=\"sby-comment-profile-pic\">\n                ".concat(dummyProfilePic, "\n            </div>\n            <div class=\"sby-comment-heading\">\n                <a href=\"").concat(authorChannelUrl, "\" target=\"_blank\" class=\"sby-comment-user-name\">").concat(authorDisplayName, "</a>\n                <span>").concat(timeAgo(publishedAt), "</span>\n            </div>\n                <div class=\"sby-comment-text\">\n                <p class=\"sby-read-more-target\">").concat(textDisplay, "</p>\n                <div class=\"sby-read-more-trigger\">\n                    <button class=\"sby-read-more-text\">Read More</button>\n                    <button class=\"sby-read-less-text\">Read Less</button>\n                </div>\n             </div>\n            <div class=\"sby-comment-bottom\">\n                <span class=\"sby-comment-likes\">\n                    ").concat(getStaticSVG('thumbs-up'), " ").concat(likeCount ? formatLargeNumber(likeCount) : 0, "\n                </span>\n                ").concat(replies, "\n            </div>\n    ");
}

/**
 * Generates the HTML template when no comments are found.
 *
 * @returns {string}
 */

function noCommentsTemplate() {
  return "\n        <h4 class=\"sby-comments-sub-heading\">Comments</h4>\n        <div class=\"sby-no-comments\">\n            ".concat(getStaticSVG('message'), "\n            <p>There are no comments to display</p>\n        </div>");
}

/**
 * Generates the HTML template when there is an error retriving comments.
 *
 * @returns {string}
 */
function errorCommentTemplate(error) {
  return "\n        <h4 class=\"sby-comments-sub-heading\">Comments</h4>\n        <div class=\"sby-no-comments\">\n            <p>".concat(error, "</p>\n        </div>");
}

/**
 * Format date and time for ISO 8601
 * 
 * @param timestamp
 * 
 * @returns {string}
 */
function timeAgo(timestamp) {
  var now = new Date();
  var past = new Date(timestamp);
  var diffMs = now - past;

  // Helper functions to get time units
  var seconds = Math.floor(diffMs / 1000);
  var minutes = Math.floor(seconds / 60);
  var hours = Math.floor(minutes / 60);
  var days = Math.floor(hours / 24);
  var months = Math.floor(days / 30);
  var years = Math.floor(months / 12);

  // Determine the largest unit of time that applies
  if (years > 0) {
    return "".concat(years, " year").concat(years > 1 ? 's' : '', " ago");
  }
  if (months > 0) {
    return "".concat(months, " month").concat(months > 1 ? 's' : '', " ago");
  }
  if (days > 0) {
    return "".concat(days, " day").concat(days > 1 ? 's' : '', " ago");
  }
  if (hours > 0) {
    return "".concat(hours, " hour").concat(hours > 1 ? 's' : '', " ago");
  }
  if (minutes > 0) {
    return "".concat(minutes, " minute").concat(minutes > 1 ? 's' : '', " ago");
  }
  if (seconds > 0) {
    return "".concat(seconds, " second").concat(seconds > 1 ? 's' : '', " ago");
  }
  return 'just now';
}

/**
 * Converts plain text into HTML with clickable links.
 * 
 * @param {string} text
 * 
 * @returns {string} 
 */
function addLinksTotext(text) {
  //Add links to the caption
  if (!text) {
    return '';
  }
  text = text.replace(/(>#)/g, '> #');
  return sbyLinkify(text);
}

/**
 * Convert Unix timestamp to milliseconds
 * @param timestamp
 * @returns {string}
 */

function convertUnixToMs(timestamp) {
  if (!timestamp) {
    return '';
  }
  return new Date(parseInt(timestamp) * 1000);
}

/**
 * Toggles the visibility of accordion sections based on the trigger element.
 * 
 * @param {string} className
 * @param {string} target
 * @param {string} parent
 * @param {string} trigger 
 * 
 * @returns {void} 
 */
function toggleAccordion(className, target, parent, trigger) {
  jQuery(trigger).css('display', 'none');
  jQuery(target).unbind('click');
  jQuery(target).click(function () {
    jQuery(this).toggleClass(className + '-trigger');
    jQuery(this).closest(parent).find(trigger).toggle();
  });
}
/**
 * Toggles the visibility of "Read More" buttons
 * 
 * @returns {void}
 */
function toggleReadMore() {
  var target = jQuery('.sby-read-more-target');
  var triggerClassName = '.sby-read-more-trigger';
  target.each(function (e) {
    var currentTarget = jQuery(this)[0];
    var paragraphHeight = currentTarget.scrollHeight;
    var clientHeight = currentTarget.offsetHeight;
    var hasMoreThanFourLines = paragraphHeight > clientHeight && paragraphHeight > clientHeight + 1; // clientHeight + 1 to fix firefox clientHeight calculate issue.

    if (hasMoreThanFourLines) {
      var trigger = jQuery(this).parent().find(triggerClassName);
      trigger.unbind('click');
      trigger.click(function () {
        jQuery(this).toggleClass('sby-read-more-trigger-active');
        jQuery(this).parent().find('.sby-read-more-target').toggleClass('sby-read-more-target-active');
      });
    } else {
      jQuery(this).parent().find(triggerClassName).hide();
    }
  });
}

/**
 * Applies a color scheme class to the lightbox based on the flag provided.
 * 
 * @param {string} colorScheme 
 * @param {boolean} flag
 */
function LightboxColorScheme(colorScheme, flag) {
  var commentWrap = jQuery('.sby_lb-caption');
  var colorSchemeClassName = 'sby-lb-dark-scheme';
  if (false === flag) {
    commentWrap.removeClass(colorSchemeClassName);
    return false;
  }
  if ('dark' === colorScheme && true === flag) {
    commentWrap.addClass(colorSchemeClassName);
    return false;
  }
}

/**
 * Resets the body's overflow style and the lightbox color scheme when the lightbox is closed.
 *
 * @returns {void}
 */
function lightboxOnClose() {
  jQuery('body').css('overflow', 'auto');
  LightboxColorScheme('', false);
}

/**
 * Retrieves the layout type of the closest ancestor element with a specific layout class.
 *
 * @param {jQuery|HTMLElement} target
 * @returns {string|boolean}
 */
function getLayout(target) {
  var currentTarget = target.closest('.sb_youtube');
  if (currentTarget.hasClass('sby_layout_list')) {
    return 'list';
  }
  if (currentTarget.hasClass('sby_layout_grid')) {
    return 'grid';
  }
  if (currentTarget.hasClass('sby_layout_carousel')) {
    return 'carousel';
  }
  if (currentTarget.hasClass('sby_layout_gallery')) {
    return 'gallery';
  }
  return false;
}

/**
 * Opens and displays the comments section on the page.
 * 
 * @returns {void}
 */
function openComments() {
  if (!window.sbyOptions.isPro) {
    return false;
  }
  var openCommentTrigger = jQuery('.sby-comments-trigger');
  openCommentTrigger.unbind('click');
  openCommentTrigger.click(function () {
    var commentWrapClass = '.sby-comments-wrap';
    var commentSecionWrap = jQuery(this).closest('.sby-comment-container');
    var commentSection = commentSecionWrap.find(commentWrapClass);
    var currentLayout = getLayout(jQuery(this));
    if (commentSection.text().length <= 0) {
      var commentCount;
      var videoId;
      var target;
      if ('gallery' === currentLayout) {
        var targetParent = jQuery(this).closest('.sb_youtube');
        var currentTarget = targetParent.find('.sby_item.sby_current');
        if (targetParent && currentTarget) {
          videoId = checkValue(currentTarget.attr('data-video-id'));
          commentCount = checkValue(currentTarget.find('a').attr('data-comment-count'));
          target = targetParent.find(commentWrapClass);
        }
      }
      if ('list' === currentLayout) {
        var _currentTarget = jQuery(this).closest('.sby_item');
        if (_currentTarget) {
          videoId = checkValue(_currentTarget.attr('data-video-id'));
          commentCount = checkValue(_currentTarget.find('a').attr('data-comment-count'));
          target = _currentTarget.find(commentWrapClass);
        }

        // Reset all other comments opened 
        resetComments(jQuery(this).closest('.sb_youtube'));
      }
      var atts = checkValue(jQuery(this).closest('.sb_youtube').attr('data-shortcode-atts'));
      generateCommentSection(videoId, atts, target, commentCount);
      commentSection.addClass('sby-comments-active');
    } else {
      commentSection.toggle();
      commentSection.toggleClass('sby-comments-active');
    }
    var currentTextState = commentSecionWrap.find('.sby-comments-trigger p');
    if (currentTextState) {
      changeTextOnToggle(currentTextState, 'Show Comments', 'Hide Comments');
    }
  });
}

/**
 * Returns a valid value or an empty string based on the input.
 * @param {*} element 
 * @returns {string} 
 */
function checkValue(element) {
  return element ? element : '';
}

/**
 * Sends an AJAX request with the specified data and handles the response.
 * @param {Object} submitData
 * @param {Function} onSuccess 
 * 
 * @returns {void} 
 */
function sbyAjax(submitData, onSuccess) {
  jQuery.ajax({
    url: sbyOptions.adminAjaxUrl,
    type: 'post',
    data: submitData,
    success: onSuccess
  });
}

/**
 * Fetches and generates a comment section for a given video.
 * 
 * @param {string} videoId 
 * @param {Object} atts
 * @param {jQuery} target
 * 
 * @returns {void}
 */

function generateCommentSection(videoId, atts, target, commentCount) {
  submitData = {
    action: 'sby_get_comments',
    video_id: videoId,
    atts: atts
  };
  var onSuccess = function onSuccess(data) {
    var _commentJson$error;
    if (!data) {
      return false;
    }
    if (false === data.success) {
      target.html(errorCommentTemplate(data.data));
      return false;
    }
    var commentJson = JSON.parse(data);
    if (!commentJson) {
      return false;
    }
    if (commentJson !== null && commentJson !== void 0 && commentJson.success && false === commentJson.success) {
      target.html(errorCommentTemplate(commentJson.data));
      return false;
    }
    if (commentJson !== null && commentJson !== void 0 && commentJson.error && commentJson !== null && commentJson !== void 0 && (_commentJson$error = commentJson.error) !== null && _commentJson$error !== void 0 && _commentJson$error.message) {
      var errorMessage = commentJson.error.message;
      if (errorMessage.includes('disabled comments')) {
        errorMessage = 'Comments are turned off';
      }
      target.html(errorCommentTemplate(errorMessage));
      return false;
    }
    var noOfItems = commentJson !== null && commentJson !== void 0 && commentJson.items && commentJson !== null && commentJson !== void 0 && commentJson.items.length ? commentJson.items.length : '';
    var videoLink = videoId ? "https://www.youtube.com/watch?v=".concat(videoId) : '';
    if (!noOfItems) {
      target.html(noCommentsTemplate());
      toggleReadMore();
      return false;
    }
    currentCommentCount = commentCount ? "( ".concat(commentCount, " )") : '';
    var commentHtml = "<h4 class=\"sby-comments-sub-heading\">Comments ".concat(currentCommentCount, "</h4><ul class=\"sby-comments\">");
    jQuery.each(commentJson.items, function (index, comment) {
      var _comment$snippet, _comment$replies;
      var topLevelCommentPath = comment === null || comment === void 0 || (_comment$snippet = comment.snippet) === null || _comment$snippet === void 0 ? void 0 : _comment$snippet.topLevelComment;
      var topLevelCommentSnippet = comment === null || comment === void 0 ? void 0 : comment.snippet;

      // Generate the HTML for each comment
      commentHtml += "<li class=\"sby-comment\">".concat(commentSingleTemplate(getSingleApiData(topLevelCommentPath, 'authorProfileImageUrl'), getSingleApiData(topLevelCommentPath, 'authorDisplayName'), getSingleApiData(topLevelCommentPath, 'authorChannelUrl'), getSingleApiData(topLevelCommentPath, 'textDisplay'), getSingleApiData(topLevelCommentPath, 'likeCount'), getSingleApiData(topLevelCommentPath, 'publishedAt'), getSingleApiData(topLevelCommentSnippet, 'totalReplyCount')), "\n            <ul class=\"sby-reply-comments\">");
      if (comment !== null && comment !== void 0 && (_comment$replies = comment.replies) !== null && _comment$replies !== void 0 && _comment$replies.comments) {
        // Use $.each to loop through replies
        jQuery.each(comment.replies.comments, function (replyIndex, reply) {
          commentHtml += "<li class=\"sby-reply-comment\" >".concat(commentSingleTemplate(getSingleApiData(reply, 'authorProfileImageUrl'), getSingleApiData(reply, 'authorDisplayName'), getSingleApiData(reply, 'authorChannelUrl'), getSingleApiData(reply, 'textDisplay'), getSingleApiData(reply, 'likeCount'), getSingleApiData(reply, 'publishedAt')), "</li>");
        });
      }
      // Close the comment container
      commentHtml += "</ul></li>";
    });
    commentHtml += "</ul>";
    commentHtml += "<a href=\"".concat(videoLink, "\" target=\"_blank\" class=\"sby-view-all-button \">View all comments on YouTube</a>");
    target.html(commentHtml).fadeIn("fast");
    toggleReadMore();
    toggleAccordion('sby-active', '.sby-replies', '.sby-comment', '.sby-reply-comments');
  };
  toggleReadMore();
  sbyAjax(submitData, onSuccess);
}

/**
 * Toggles the text of an element based on its current content.
 *
 * This function updates the text of an element if the element's current text
 * matches the specified `currentText`. If it matches, the text is replaced with
 * the provided `replacementText`. If it does not match, the text remains as `currentText`.
 *
 * @param {Object} currentState
 * @param {string} currentText
 * @param {string} replacementText
 * 
 * @returns {void} 
 */

function changeTextOnToggle(currentState, currentText, replacementText) {
  if (currentState && currentText && replacementText) {
    var currentStateText = currentText === currentState.text() ? replacementText : currentText;
    currentState.text(currentStateText);
  }
}

/**
 * Resets the comments of a specified parent element.
 *
 * @param {jQuery} parent
 *
 * @returns {void} 
 */

function resetComments(parent) {
  if ('gallery' === getLayout(parent) || 'list' === getLayout(parent)) {
    var trigger = parent.find('.sby-comments-trigger');
    trigger.find('p').text('Show Comments');
    parent.find('.sby-comments-wrap').html('');
  }
}

/**
 * Formats a large number into a more readable string with a suffix.
 * The function converts large numbers into a string with a suffix to denote the scale of the number.
 *
 * @param {number} num
 * 
 * @returns {string}
 */

function formatLargeNumber(num) {
  if (num >= 1e9) return (num / 1e9).toFixed(1) + 'B';
  if (num >= 1e6) return (num / 1e6).toFixed(1) + 'M';
  if (num >= 1e3) return (num / 1e3).toFixed(1) + 'K';
  return num;
}

/**
 * Applies a set of colors to the channel header.
 * 
 * @param {Object} colorArray - An object containing color properties for the channel header.
 * @param {string} colorArray.channelName - The text color for the channel name element.
 * @param {string} colorArray.subscribeCount - The text color for the subscribe count element.
 * @param {string} colorArray.buttonBackground - The background color for the button element.
 * @param {string} colorArray.buttonText - The text color for the button element.
 * 
 * @returns {void}
 */
function setColorsToChannelHeader(colorArray) {
  var channelName = colorArray.channelName,
    subscribeCount = colorArray.subscribeCount,
    buttonBackground = colorArray.buttonBackground,
    buttonText = colorArray.buttonText;
  var parent = jQuery('.sby_lb-dataContainer .sby-lb-channel-header');
  if (!parent) {
    return false;
  }
  if (channelName) {
    parent.find('.sby-lb-channel-name-with-subs span:first-child').css('color', channelName);
  }
  if (subscribeCount) {
    parent.find('.sby-lb-channel-name-with-subs span:nth-child(2)').css('color', subscribeCount);
  }
  if (buttonBackground) {
    parent.find('.sby-lb-subscribe-btn').css('background', buttonBackground);
  }
  if (buttonText) {
    parent.find('.sby-lb-subscribe-btn').css('color', buttonText);
  }
}
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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